/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.localhistory.LocalHistorySettings;
import org.netbeans.modules.localhistory.LocalHistoryVCSAnnotator;
import org.netbeans.modules.localhistory.LocalHistoryVCSInterceptor;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.LocalHistoryStoreFactory;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHistory {
    private static LocalHistory instance;
    private VCSInterceptor vcsInterceptor;
    private VCSAnnotator vcsAnnotator;
    private LocalHistoryStore store;
    private ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private Set<File> userDefinedRoots;
    private Set<File> roots = new HashSet<File>();
    private Pattern includeFiles = null;
    private Pattern excludeFiles = null;
    private final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "((\\.|_)svn|.hg|CVS)(\\" + File.separatorChar + ".*|$)");
    public static final Object EVENT_FILE_CREATED;
    static final Object EVENT_PROJECTS_CHANGED;
    public static final Logger LOG;
    PropertyChangeListener openProjectsListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("openProjects")) {
                final Project[] projectArray = (Project[])propertyChangeEvent.getNewValue();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        LocalHistory.this.setRoots(projectArray);
                    }
                });
            }
        }
    };

    public LocalHistory() {
        String string;
        String string2;
        String string3 = System.getProperty("netbeans.localhistory.includeFiles");
        if (string3 != null && !string3.trim().equals("")) {
            this.includeFiles = Pattern.compile(string3);
        }
        if ((string2 = System.getProperty("netbeans.localhistory.excludeFiles")) != null && !string2.trim().equals("")) {
            this.excludeFiles = Pattern.compile(string2);
        }
        if ((string = System.getProperty("netbeans.localhistory.historypath")) == null || string.trim().equals("")) {
            this.userDefinedRoots = Collections.EMPTY_SET;
        } else {
            String[] stringArray = string.split(";");
            this.userDefinedRoots = new HashSet<File>(stringArray.length);
            for (String string4 : stringArray) {
                this.addRootFile(this.userDefinedRoots, new File(string4));
            }
        }
    }

    void init() {
        LocalHistoryStore localHistoryStore = this.getLocalHistoryStore(false);
        if (localHistoryStore != null) {
            this.getLocalHistoryStore().cleanUp(LocalHistorySettings.getInstance().getTTLMillis());
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                LocalHistory.this.setRoots(OpenProjects.getDefault().getOpenProjects());
                OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)LocalHistory.this.openProjectsListener, null));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRoots(Project[] projectArray) {
        HashSet<File> hashSet = new HashSet<File>();
        for (Project project : projectArray) {
            SourceGroup[] sourceGroupArray;
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("generic")) {
                FileObject fileObject = sourceGroup.getRootFolder();
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    LOG.warning("source group" + sourceGroup.getDisplayName() + " returned null root folder");
                    continue;
                }
                this.addRootFile(hashSet, file);
            }
            File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
            if (file == null) {
                LOG.warning("project " + project.getProjectDirectory() + " returned null root folder");
                continue;
            }
            this.addRootFile(hashSet, file);
        }
        Set<File> set = this.roots;
        synchronized (set) {
            this.roots = hashSet;
        }
        this.fireFileEvent(EVENT_PROJECTS_CHANGED, null);
    }

    private void addRootFile(Set<File> set, File file) {
        if (file == null) {
            return;
        }
        LOG.fine("adding root folder " + file);
        set.add(file);
    }

    public static synchronized LocalHistory getInstance() {
        if (instance == null) {
            instance = new LocalHistory();
        }
        return instance;
    }

    VCSInterceptor getVCSInterceptor() {
        if (this.vcsInterceptor == null) {
            this.vcsInterceptor = new LocalHistoryVCSInterceptor();
        }
        return this.vcsInterceptor;
    }

    VCSAnnotator getVCSAnnotator() {
        if (this.vcsAnnotator == null) {
            this.vcsAnnotator = new LocalHistoryVCSAnnotator();
        }
        return this.vcsAnnotator;
    }

    public LocalHistoryStore getLocalHistoryStore() {
        return this.getLocalHistoryStore(true);
    }

    public LocalHistoryStore getLocalHistoryStore(boolean bl) {
        if (this.store == null) {
            this.store = LocalHistoryStoreFactory.getInstance().createLocalHistoryStorage(bl);
        }
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File isManagedByParent(File file) {
        if (this.roots == null) {
            return file;
        }
        File file2 = null;
        while (file != null) {
            Set<File> set = this.roots;
            synchronized (set) {
                if (this.roots.contains(file) || this.userDefinedRoots.contains(file)) {
                    file2 = file;
                }
            }
            file = file.getParentFile();
        }
        return file2;
    }

    boolean isManaged(File file) {
        LocalHistory.log("isManaged() " + file);
        if (file == null) {
            return false;
        }
        String string = file.getAbsolutePath();
        if (this.metadataPattern.matcher(string).matches()) {
            return false;
        }
        if (this.includeFiles != null) {
            return this.includeFiles.matcher(string).matches();
        }
        if (this.excludeFiles != null) {
            return !this.excludeFiles.matcher(string).matches();
        }
        return true;
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    void fireFileEvent(Object object, File file) {
        this.listenerSupport.fireVersioningEvent(object, new Object[]{file});
    }

    public static void logCreate(File file, File file2, long l, String string, String string2) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create");
        stringBuffer.append('\t');
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append('\t');
        stringBuffer.append(file2.getAbsolutePath());
        stringBuffer.append('\t');
        stringBuffer.append(l);
        stringBuffer.append('\t');
        stringBuffer.append(string);
        stringBuffer.append('\t');
        stringBuffer.append(string2);
        LocalHistory.log(stringBuffer.toString());
    }

    public static void logChange(File file, File file2, long l) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("change");
        stringBuffer.append('\t');
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append('\t');
        stringBuffer.append(file2.getAbsolutePath());
        stringBuffer.append('\t');
        stringBuffer.append(l);
        LocalHistory.log(stringBuffer.toString());
    }

    public static void logDelete(File file, File file2, long l) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete");
        stringBuffer.append('\t');
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append('\t');
        stringBuffer.append(file2.getAbsolutePath());
        stringBuffer.append('\t');
        stringBuffer.append(l);
        LocalHistory.log(stringBuffer.toString());
    }

    public static void logFile(String string, File file) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('\t');
        stringBuffer.append(file.getAbsolutePath());
        LocalHistory.log(stringBuffer.toString());
    }

    public static void log(String string) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy:HH-mm-ss.S");
        stringBuffer.append(simpleDateFormat.format(new Date(System.currentTimeMillis())));
        stringBuffer.append(":");
        stringBuffer.append(string);
        stringBuffer.append('\t');
        stringBuffer.append(Thread.currentThread().getName());
        LOG.fine(stringBuffer.toString());
    }

    static {
        EVENT_FILE_CREATED = new Object();
        EVENT_PROJECTS_CHANGED = new Object();
        LOG = Logger.getLogger("org.netbeans.modules.localhistory");
    }
}

