/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.validator.ValidatorSchemaFactoryRegistry;
import org.netbeans.modules.xml.wsdl.validator.spi.ValidatorSchemaFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLSchemaValidator
extends XsdBasedValidator {
    static final String wsdlXSDUrl = "/org/netbeans/modules/xml/wsdl/validator/resources/wsdl-2004-08-24.xsd";

    public String getName() {
        return "WSDLSchemaValidator";
    }

    protected Schema getSchema(Model model) {
        if (!(model instanceof WSDLModel)) {
            return null;
        }
        InputStream inputStream = WSDLSchemaValidator.class.getResourceAsStream(wsdlXSDUrl);
        StreamSource streamSource = new StreamSource(inputStream);
        streamSource.setSystemId(WSDLSchemaValidator.class.getResource(wsdlXSDUrl).toString());
        Collection<ValidatorSchemaFactory> collection = ValidatorSchemaFactoryRegistry.getDefault().getAllValidatorSchemaFactories();
        ArrayList<Source> arrayList = new ArrayList<Source>();
        arrayList.add(streamSource);
        for (ValidatorSchemaFactory validatorSchemaFactory : collection) {
            Source source = validatorSchemaFactory.getSchemaSource();
            if (source != null) {
                arrayList.add(source);
                continue;
            }
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).severe("getSchema: " + validatorSchemaFactory.getClass() + " returned null input stream for its schema");
        }
        Schema schema = this.getCompiledSchema(arrayList.toArray(new Source[arrayList.size()]), new CentralLSResourceResolver(collection), new SchemaErrorHandler());
        return schema;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CentralLSResourceResolver
    implements LSResourceResolver {
        private Collection<ValidatorSchemaFactory> mExtSchemaFactories;

        CentralLSResourceResolver(Collection<ValidatorSchemaFactory> collection) {
            this.mExtSchemaFactories = collection;
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            ValidatorSchemaFactory validatorSchemaFactory;
            LSResourceResolver lSResourceResolver;
            LSInput lSInput = null;
            Iterator<ValidatorSchemaFactory> iterator = this.mExtSchemaFactories.iterator();
            while (iterator.hasNext() && ((lSResourceResolver = (validatorSchemaFactory = iterator.next()).getLSResourceResolver()) == null || (lSInput = lSResourceResolver.resolveResource(string, string2, string3, string4, string5)) == null)) {
            }
            return lSInput;
        }
    }

    class SchemaErrorHandler
    implements ErrorHandler {
        SchemaErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "SchemaErrorHandler: " + sAXParseException.getMessage(), sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "SchemaErrorHandler: " + sAXParseException.getMessage(), sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

