/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sessions;

import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class ObjectCopyingPolicy {
    protected boolean shouldResetPrimaryKey = true;
    protected AbstractSession session;
    protected IdentityHashtable copies = new IdentityHashtable();
    protected int depth = 2;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;

    public void cascadeAllParts() {
        this.setDepth(3);
    }

    public void cascadePrivateParts() {
        this.setDepth(2);
    }

    public void dontCascade() {
        this.setDepth(1);
    }

    public IdentityHashtable getCopies() {
        return this.copies;
    }

    public int getDepth() {
        return this.depth;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setCopies(IdentityHashtable newCopies) {
        this.copies = newCopies;
    }

    public void setDepth(int newDepth) {
        this.depth = newDepth;
    }

    public void setSession(AbstractSession newSession) {
        this.session = newSession;
    }

    public void setShouldResetPrimaryKey(boolean newShouldResetPrimaryKey) {
        this.shouldResetPrimaryKey = newShouldResetPrimaryKey;
    }

    public boolean shouldCascade() {
        return this.getDepth() != 1;
    }

    public boolean shouldCascadeAllParts() {
        return this.getDepth() == 3;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getDepth() == 2;
    }

    public boolean shouldResetPrimaryKey() {
        return this.shouldResetPrimaryKey;
    }

    public String toString() {
        String depthString = "";
        depthString = this.shouldCascadeAllParts() ? "CASCADE_ALL_PARTS" : (this.shouldCascadePrivateParts() ? "CASCADE_PRIVATE_PARTS" : "NO_CASCADING");
        Object[] args = new Object[]{depthString, new Boolean(this.shouldResetPrimaryKey())};
        return Helper.getShortClassName(this) + ToStringLocalization.buildMessage("depth_reset_key", args);
    }
}

