/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;

public class HtmlAutoCompletion {
    public static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (c == '=') {
            HtmlAutoCompletion.completeQuotes(baseDocument, n, caret);
        } else if (c == '\"') {
            HtmlAutoCompletion.handleQuotationMark(baseDocument, n, caret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleQuotationMark(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        baseDocument.readLock();
        try {
            TokenSequence tokenSequence = HtmlSyntaxSupport.getJoinedHtmlSequence((Document)baseDocument);
            if (tokenSequence == null) {
                return;
            }
            int n2 = tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == HTMLTokenId.VALUE) {
                if ("\"\"".equals(baseDocument.getText(n, 2))) {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                } else if (n2 == 0 && token.text().charAt(0) == '\"') {
                    baseDocument.insertString(n, "\"", null);
                    caret.setDot(n + 1);
                }
            }
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void completeQuotes(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        baseDocument.readLock();
        try {
            TokenSequence tokenSequence = HtmlSyntaxSupport.getJoinedHtmlSequence((Document)baseDocument);
            if (tokenSequence == null) {
                return;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            int n2 = n + 1;
            if (token != null && token.id() == HTMLTokenId.OPERATOR) {
                baseDocument.insertString(n2, "\"\"", null);
                caret.setDot(n2 + 1);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
    }
}

