/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collections;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.HtmlSyntaxSupport;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.modules.html.editor.Utils;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.openide.util.Exceptions;

public class HtmlBracesMatching
implements BracesMatcher,
BracesMatcherFactory {
    private MatcherContext context;
    private LanguagePath htmlLanguagePath;
    private static final String BLOCK_COMMENT_START = "<!--";
    private static final String BLOCK_COMMENT_END = "-->";
    static boolean testMode = false;

    public HtmlBracesMatching() {
        this(null, null);
    }

    private HtmlBracesMatching(MatcherContext matcherContext, LanguagePath languagePath) {
        this.context = matcherContext;
        this.htmlLanguagePath = languagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            if (!testMode && MatcherContext.isTaskCanceled()) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence tokenSequence = HtmlSyntaxSupport.getJoinedHtmlSequence((Document)this.context.getDocument());
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
            if (tokenSequence.language() == HTMLTokenId.language()) {
                tokenSequence.move(this.context.getSearchOffset());
                if (tokenSequence.moveNext()) {
                    if (this.context.isSearchingBackward() && tokenSequence.offset() + tokenSequence.token().length() < this.context.getSearchOffset()) {
                        int[] nArray = null;
                        return nArray;
                    }
                    token = tokenSequence.token();
                    if (this.tokenInTag(token)) {
                        do {
                            Token token2;
                            if (!this.tokenInTag(token2 = tokenSequence.token())) {
                                int[] nArray = null;
                                return nArray;
                            }
                            if (token2.id() != HTMLTokenId.TAG_OPEN_SYMBOL) continue;
                            int n = -1;
                            while (tokenSequence.moveNext()) {
                                Token token3 = tokenSequence.token();
                                if (!this.tokenInTag(token3) || token3.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                                    int[] nArray = null;
                                    return nArray;
                                }
                                if (token3.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                                    if ("/>".equals(((Object)token3.text()).toString())) {
                                        int[] nArray = null;
                                        return nArray;
                                    }
                                    int n2 = token2.offset(tokenHierarchy);
                                    int n3 = token3.offset(tokenHierarchy) + token3.length();
                                    if (n != -1) {
                                        int[] nArray = new int[]{n2, n3, n2, n, n3 - 1, n3};
                                        return nArray;
                                    }
                                    int[] nArray = new int[]{n2, n3};
                                    return nArray;
                                }
                                if (token3.id() != HTMLTokenId.TAG_OPEN && token3.id() != HTMLTokenId.TAG_CLOSE) continue;
                                n = token3.offset(tokenHierarchy) + token3.length();
                            }
                            break;
                        } while (tokenSequence.movePrevious());
                    } else if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                        String string = ((Object)token.text()).toString();
                        if (string.startsWith(BLOCK_COMMENT_START) && this.context.getSearchOffset() < token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()) {
                            int[] nArray = new int[]{token.offset(tokenHierarchy), token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()};
                            return nArray;
                        }
                        if (string.endsWith(BLOCK_COMMENT_END) && this.context.getSearchOffset() >= token.offset(tokenHierarchy) + string.length() - BLOCK_COMMENT_END.length()) {
                            int[] nArray = new int[]{token.offset(tokenHierarchy) + token.length() - BLOCK_COMMENT_END.length(), token.offset(tokenHierarchy) + token.length()};
                            return nArray;
                        }
                    }
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean tokenInTag(Token token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.VALUE_CSS || token.id() == HTMLTokenId.VALUE_JAVASCRIPT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.EOL;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (!testMode && MatcherContext.isTaskCanceled()) {
            return null;
        }
        final Source source = Source.create((Document)this.context.getDocument());
        if (source == null) {
            return null;
        }
        final int[][] nArrayArray = new int[1][];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    int n;
                    if (!testMode && MatcherContext.isTaskCanceled()) {
                        return;
                    }
                    if (!source.getMimeType().equals("text/html")) {
                        resultIterator = Utils.getResultIterator(resultIterator, "text/html");
                    }
                    if (resultIterator == null) {
                        nArrayArray[0] = new int[]{HtmlBracesMatching.this.context.getSearchOffset(), HtmlBracesMatching.this.context.getSearchOffset()};
                        return;
                    }
                    HtmlParserResult htmlParserResult = (HtmlParserResult)resultIterator.getParserResult();
                    if (htmlParserResult == null) {
                        return;
                    }
                    AstNode astNode = htmlParserResult.root();
                    AstNode astNode2 = AstNodeUtils.findDescendant((AstNode)astNode, (int)(n = htmlParserResult.getSnapshot().getEmbeddedOffset(HtmlBracesMatching.this.context.getSearchOffset())));
                    if (astNode2 != null) {
                        if (astNode2.type() == AstNode.NodeType.OPEN_TAG || astNode2.type() == AstNode.NodeType.ENDTAG) {
                            if ((astNode2 = AstNodeUtils.getTagNode((AstNode)astNode2, (int)n)) == null) {
                                nArrayArray[0] = null;
                            } else {
                                AstNode astNode3 = astNode2.getMatchingTag();
                                if (astNode3 == null) {
                                    nArrayArray[0] = (int[])(astNode2.needsToHaveMatchingTag() ? null : new int[]{HtmlBracesMatching.this.context.getSearchOffset(), HtmlBracesMatching.this.context.getSearchOffset()});
                                } else if (astNode3.type() == AstNode.NodeType.OPEN_TAG) {
                                    int n2 = astNode3.startOffset();
                                    int n3 = n2 + astNode3.name().length() + 1;
                                    int n4 = astNode3.endOffset() - 1;
                                    int n5 = astNode3.endOffset();
                                    nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{n2, n3, n4, n5}, (Parser.Result)htmlParserResult);
                                } else {
                                    nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{astNode3.startOffset(), astNode3.endOffset()}, (Parser.Result)htmlParserResult);
                                }
                            }
                        } else if (astNode2.type() == AstNode.NodeType.COMMENT) {
                            if (n >= astNode2.startOffset() && n <= astNode2.startOffset() + HtmlBracesMatching.BLOCK_COMMENT_START.length()) {
                                nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{astNode2.endOffset() - HtmlBracesMatching.BLOCK_COMMENT_END.length(), astNode2.endOffset()}, (Parser.Result)htmlParserResult);
                            } else if (n >= astNode2.endOffset() - HtmlBracesMatching.BLOCK_COMMENT_END.length() && n <= astNode2.endOffset()) {
                                nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{astNode2.startOffset(), astNode2.startOffset() + HtmlBracesMatching.BLOCK_COMMENT_START.length()}, (Parser.Result)htmlParserResult);
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return nArrayArray[0];
    }

    private int[] translate(int[] nArray, Parser.Result result) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = result.getSnapshot().getOriginalOffset(nArray[i]);
        }
        return nArray2;
    }

    public BracesMatcher createMatcher(final MatcherContext matcherContext) {
        final HtmlBracesMatching[] htmlBracesMatchingArray = new HtmlBracesMatching[]{null};
        matcherContext.getDocument().render(new Runnable(){

            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)matcherContext.getDocument());
                if (tokenHierarchy.tokenSequence().language() == HTMLTokenId.language()) {
                    htmlBracesMatchingArray[0] = new HtmlBracesMatching(matcherContext, tokenHierarchy.tokenSequence().languagePath());
                    return;
                }
                List list = tokenHierarchy.embeddedTokenSequences(matcherContext.getSearchOffset(), matcherContext.isSearchingBackward());
                for (TokenSequence tokenSequence : list) {
                    Language language = tokenSequence.language();
                    if (language != HTMLTokenId.language()) continue;
                    htmlBracesMatchingArray[0] = new HtmlBracesMatching(matcherContext, tokenSequence.languagePath());
                    return;
                }
            }
        });
        return htmlBracesMatchingArray[0];
    }
}

