/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.HtmlCaretAwareSourceTask;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class NavigationSideBar
extends JPanel
implements Accessible {
    private JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final FileObject fileObject;
    private final Document doc;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            NavigationSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigationSideBar.this.repaint();
                }
            });
        }
    };
    private boolean enabled = true;
    private List<AstNode> nesting = new ArrayList<AstNode>(5);

    public NavigationSideBar() {
        this.doc = null;
        this.fileObject = null;
    }

    public NavigationSideBar(JTextComponent jTextComponent) {
        this.setLayout(new FlowLayout(0, 17, 0));
        this.component = jTextComponent;
        this.doc = jTextComponent.getDocument();
        this.fileObject = DataLoadersBridge.getDefault().getFileObject(this.doc);
        HtmlCaretAwareSourceTask.Source source = HtmlCaretAwareSourceTask.forDocument(this.doc);
        source.addChangeListener(new HtmlCaretAwareSourceTask.SourceListener(){

            public void parsed(Parser.Result result, SchedulerEvent schedulerEvent) {
                NavigationSideBar.this.change(result, schedulerEvent);
            }
        });
        this.updatePreferredSize();
    }

    private void change(Parser.Result result, SchedulerEvent schedulerEvent) {
        int n = ((CursorMovedSchedulerEvent)schedulerEvent).getCaretOffset();
        AstNode astNode = ((HtmlParserResult)result).root();
        AstNode astNode2 = AstNodeUtils.findDescendant((AstNode)astNode, (int)result.getSnapshot().getEmbeddedOffset(n));
        if (astNode2 == null) {
            return;
        }
        this.updateNestingInfo(result, astNode, astNode2);
    }

    private void updateNestingInfo(final Parser.Result result, AstNode astNode, AstNode astNode2) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        do {
            if (astNode2.type() != AstNode.NodeType.OPEN_TAG) continue;
            arrayList.add(0, astNode2);
        } while ((astNode2 = astNode2.parent()) != null && astNode2 != astNode);
        this.nesting = arrayList;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NavigationSideBar.this.updatePanelUI(result);
            }
        });
    }

    private void updatePanelUI(final Parser.Result result) {
        this.removeAll();
        for (final AstNode astNode : this.nesting) {
            final JLabel jLabel = new JLabel();
            jLabel.setForeground(Color.BLACK);
            jLabel.setFont(new Font("Courier New", 0, this.getColoring().getFont().getSize()));
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
            jLabel.setText(this.getDrawText(astNode.name()));
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.BLUE);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.BLACK);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = result.getSnapshot().getOriginalOffset(astNode.startOffset());
                    NavigationSideBar.this.component.getCaret().setDot(n);
                }
            });
            this.add(jLabel);
        }
        this.revalidate();
        this.repaint();
    }

    private String getDrawText(String string) {
        return string;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.component.getWidth(), this.getColoring().getFont().getSize() + 4));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            FontColorSettings fontColorSettings = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next();
            this.attribs = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.attribs, fontColorSettings.getFontColors("default")});
        }
        return Coloring.fromAttributeSet((AttributeSet)this.attribs);
    }

    public static final class NavigationSideBarFactory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent jTextComponent) {
            return new NavigationSideBar(jTextComponent);
        }
    }
}

