/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.SurroundWithFix;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class AbbrevDetection
implements DocumentListener,
PropertyChangeListener,
KeyListener,
CaretListener,
PreferenceChangeListener {
    private static final Logger LOG = Logger.getLogger(AbbrevDetection.class.getName());
    private static final String ABBREV_IGNORE_MODIFICATION_DOC_PROPERTY = "abbrev-ignore-modification";
    private static final String COMPLETION_VISIBLE = "completion-visible";
    private static final String EDITING_TEMPLATE_DOC_PROPERTY = "processing-code-template";
    private static final String SURROUND_WITH = NbBundle.getMessage(SurroundWithFix.class, (String)"TXT_SurroundWithHint_Label");
    private static final int SURROUND_WITH_DELAY = 250;
    private JTextComponent component;
    private Document doc;
    private Position abbrevEndPosition;
    private final StringBuffer abbrevChars = new StringBuffer();
    private Acceptor resetAcceptor;
    private MimePath mimePath = null;
    private Preferences prefs = null;
    private PreferenceChangeListener weakPrefsListener = null;
    private ErrorDescription errorDescription = null;
    private List<Fix> surrounsWithFixes = null;
    private Timer surroundsWithTimer;

    public static AbbrevDetection get(JTextComponent jTextComponent) {
        AbbrevDetection abbrevDetection = (AbbrevDetection)jTextComponent.getClientProperty(AbbrevDetection.class);
        if (abbrevDetection == null) {
            abbrevDetection = new AbbrevDetection(jTextComponent);
            jTextComponent.putClientProperty(AbbrevDetection.class, abbrevDetection);
        }
        return abbrevDetection;
    }

    public static synchronized void remove(JTextComponent jTextComponent) {
        AbbrevDetection abbrevDetection = (AbbrevDetection)jTextComponent.getClientProperty(AbbrevDetection.class);
        if (abbrevDetection != null) {
            assert (abbrevDetection.component == jTextComponent) : "Wrong component: AbbrevDetection.component=" + abbrevDetection.component + ", component=" + jTextComponent;
            abbrevDetection.uninstall();
            jTextComponent.putClientProperty(AbbrevDetection.class, null);
        }
    }

    private AbbrevDetection(JTextComponent jTextComponent) {
        String string;
        this.component = jTextComponent;
        jTextComponent.addCaretListener(this);
        this.doc = jTextComponent.getDocument();
        if (this.doc != null) {
            this.doc.addDocumentListener(this);
        }
        if ((string = DocumentUtilities.getMimeType((JTextComponent)jTextComponent)) != null) {
            this.mimePath = MimePath.parse((String)string);
            this.prefs = (Preferences)MimeLookup.getLookup((MimePath)this.mimePath).lookup(Preferences.class);
            this.weakPrefsListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs);
            this.prefs.addPreferenceChangeListener(this.weakPrefsListener);
        }
        this.preferenceChange(null);
        jTextComponent.addKeyListener(this);
        jTextComponent.addPropertyChangeListener(this);
        this.surroundsWithTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DocumentUtilities.isReadLocked((Document)AbbrevDetection.this.doc)) {
                    AbbrevDetection.this.showSurroundWithHint();
                }
            }
        });
        this.surroundsWithTimer.setRepeats(false);
    }

    private void uninstall() {
        assert (this.component != null) : "Can't call uninstall before the construction finished";
        this.component.removeCaretListener(this);
        if (this.doc != null) {
            this.doc.addDocumentListener(this);
        }
        this.component.removeKeyListener(this);
        this.component.removePropertyChangeListener(this);
        this.surroundsWithTimer.stop();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string;
        String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
        if (string == null || "abbrev-reset-acceptor".equals(string)) {
            if (this.prefs != null) {
                this.resetAcceptor = (Acceptor)AbbrevDetection.callFactory(this.prefs, this.mimePath, "abbrev-reset-acceptor", null);
            }
            if (this.resetAcceptor == null) {
                this.resetAcceptor = AcceptorFactory.WHITESPACE;
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.isIgnoreModification()) {
            if (DocumentUtilities.isTypingModification((Document)documentEvent.getDocument()) && !this.isAbbrevDisabled()) {
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                this.appendTypedText(n, n2);
            } else {
                this.resetAbbrevChars();
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.isIgnoreModification()) {
            if (DocumentUtilities.isTypingModification((Document)documentEvent.getDocument()) && !this.isAbbrevDisabled()) {
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                this.removeAbbrevText(n, n2);
            } else {
                this.resetAbbrevChars();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            String string;
            if (this.doc != null) {
                this.doc.removeDocumentListener(this);
            }
            this.doc = this.component.getDocument();
            if (this.doc != null) {
                this.doc.addDocumentListener(this);
            }
            if (this.prefs != null) {
                this.prefs.removePreferenceChangeListener(this.weakPrefsListener);
                this.prefs = null;
                this.weakPrefsListener = null;
                this.mimePath = null;
            }
            if ((string = DocumentUtilities.getMimeType((JTextComponent)this.component)) != null) {
                this.mimePath = MimePath.parse((String)string);
                this.prefs = (Preferences)MimeLookup.getLookup((MimePath)this.mimePath).lookup(Preferences.class);
                this.weakPrefsListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs);
                this.prefs.addPreferenceChangeListener(this.weakPrefsListener);
            }
            this.preferenceChange(null);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.checkExpansionKeystroke(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.checkExpansionKeystroke(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.checkExpansionKeystroke(keyEvent);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getDot() != caretEvent.getMark()) {
            this.surroundsWithTimer.setInitialDelay(250);
            this.surroundsWithTimer.restart();
        } else {
            this.surroundsWithTimer.stop();
            this.hideSurroundWithHint();
        }
    }

    private boolean isIgnoreModification() {
        return Boolean.TRUE.equals(this.doc.getProperty(ABBREV_IGNORE_MODIFICATION_DOC_PROPERTY));
    }

    private boolean isAbbrevDisabled() {
        return Abbrev.isAbbrevDisabled((JTextComponent)this.component) || Boolean.TRUE.equals(this.component.getClientProperty(COMPLETION_VISIBLE));
    }

    private void checkExpansionKeystroke(KeyEvent keyEvent) {
        KeyStroke keyStroke;
        CodeTemplateManagerOperation codeTemplateManagerOperation;
        if (this.abbrevEndPosition != null && this.component != null && this.component.getCaretPosition() == this.abbrevEndPosition.getOffset() && !this.isAbbrevDisabled() && !Boolean.TRUE.equals(this.doc.getProperty(EDITING_TEMPLATE_DOC_PROPERTY)) && (codeTemplateManagerOperation = CodeTemplateManagerOperation.get(this.component.getDocument(), this.abbrevEndPosition.getOffset())) != null && (keyStroke = codeTemplateManagerOperation.getExpansionKey()).equals(KeyStroke.getKeyStrokeForEvent(keyEvent)) && this.expand(codeTemplateManagerOperation)) {
            keyEvent.consume();
        }
    }

    private CharSequence getAbbrevText() {
        return this.abbrevChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAbbrevChars() {
        StringBuffer stringBuffer = this.abbrevChars;
        synchronized (stringBuffer) {
            this.abbrevChars.setLength(0);
            this.abbrevEndPosition = null;
        }
    }

    private void appendTypedText(int n, int n2) {
        if (this.abbrevEndPosition == null || n + n2 != this.abbrevEndPosition.getOffset()) {
            this.resetAbbrevChars();
        }
        if (this.abbrevEndPosition == null) {
            try {
                if (n == 0 || this.resetAcceptor.accept(DocumentUtilities.getText((Document)this.doc, (int)(n - 1), (int)1).charAt(0))) {
                    this.abbrevEndPosition = this.doc.createPosition(n + n2);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        if (this.abbrevEndPosition != null) {
            try {
                String string = this.doc.getText(n, n2);
                boolean bl = true;
                for (int i = string.length() - 1; i >= 0; --i) {
                    if (!this.resetAcceptor.accept(string.charAt(i))) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.abbrevChars.append(string);
                } else {
                    this.resetAbbrevChars();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
                this.resetAbbrevChars();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbbrevText(int n, int n2) {
        StringBuffer stringBuffer = this.abbrevChars;
        synchronized (stringBuffer) {
            if (this.abbrevEndPosition != null) {
                if (n == this.abbrevEndPosition.getOffset() && this.abbrevChars.length() >= n2) {
                    this.abbrevChars.setLength(this.abbrevChars.length() - n2);
                } else {
                    this.resetAbbrevChars();
                }
            }
        }
    }

    public boolean expand(CodeTemplateManagerOperation codeTemplateManagerOperation) {
        CharSequence charSequence = this.getAbbrevText();
        int n = this.abbrevEndPosition.getOffset();
        if (AbbrevDetection.expand(codeTemplateManagerOperation, this.component, n - charSequence.length(), charSequence)) {
            this.resetAbbrevChars();
            return true;
        }
        return false;
    }

    private void showSurroundWithHint() {
        this.surrounsWithFixes = SurroundWithFix.getFixes(this.component);
        if (!this.surrounsWithFixes.isEmpty()) {
            try {
                Position position = this.doc.createPosition(this.component.getCaretPosition());
                this.errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)SURROUND_WITH, this.surrounsWithFixes, (Document)this.doc, (Position)position, (Position)position);
                HintsController.setErrors((Document)this.doc, (String)SURROUND_WITH, Collections.singleton(this.errorDescription));
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.WARNING, badLocationException.getMessage(), badLocationException);
            }
        } else {
            this.hideSurroundWithHint();
        }
    }

    private void hideSurroundWithHint() {
        if (this.surrounsWithFixes != null) {
            this.surrounsWithFixes = null;
        }
        if (this.errorDescription != null) {
            this.errorDescription = null;
            HintsController.setErrors((Document)this.doc, (String)SURROUND_WITH, Collections.emptySet());
        }
    }

    private static Object callFactory(Preferences preferences, MimePath mimePath, String string, Object object) {
        String string2 = preferences.get(string, null);
        if (string2 != null) {
            int n = string2.lastIndexOf(46);
            assert (n != -1) : "Need fully qualified name of class with the static setting factory method.";
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                Method method;
                Class<?> clazz = classLoader.loadClass(string3);
                try {
                    method = clazz.getDeclaredMethod(string4, MimePath.class, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getDeclaredMethod(string4, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw noSuchMethodException;
                    }
                }
                Object object2 = method.getParameterTypes().length == 2 ? method.invoke(null, mimePath, string) : method.invoke(null, new Object[0]);
                if (object2 != null) {
                    return object2;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
            }
        }
        return object;
    }

    private static boolean expand(CodeTemplateManagerOperation codeTemplateManagerOperation, JTextComponent jTextComponent, int n, CharSequence charSequence) {
        codeTemplateManagerOperation.waitLoaded();
        CodeTemplate codeTemplate = codeTemplateManagerOperation.findByAbbreviation(((Object)charSequence).toString());
        if (codeTemplate != null) {
            try {
                Document document = jTextComponent.getDocument();
                document.remove(n, charSequence.length());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            codeTemplate.insert(jTextComponent);
            return true;
        }
        return false;
    }
}

