/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config.mdb;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.jboss4.config.ResourceConfigurationHelper;
import org.netbeans.modules.j2ee.jboss4.config.gen.Depends;
import org.netbeans.modules.j2ee.jboss4.config.gen.Mbean;
import org.netbeans.modules.j2ee.jboss4.config.gen.Server;
import org.netbeans.modules.j2ee.jboss4.config.mdb.JBossMessageDestination;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDestinationSupport {
    public static final String MSG_DEST_RESOURCE_NAME_JB4 = "jboss4-netbeans-destinations-service.xml";
    public static final String MSG_DEST_RESOURCE_NAME_JB5 = "jboss5-netbeans-destinations-service.xml";
    public static final String CONN_FACTORY_JNDI_NAME_JB4 = "ConnectionFactory";
    private File resourceDir;
    private Server destinationServiceModel;
    private File destinationsFile;
    private FileObject destinationsFO;

    public MessageDestinationSupport(File file) {
        this.resourceDir = file;
        this.destinationsFile = new File(file, MSG_DEST_RESOURCE_NAME_JB4);
        this.ensureDestinationsFOExists();
    }

    private void ensureDestinationsFOExists() {
        if (!this.destinationsFile.exists()) {
            return;
        }
        if (this.destinationsFO == null || !this.destinationsFO.isValid()) {
            this.destinationsFO = FileUtil.toFileObject((File)this.destinationsFile);
            assert (this.destinationsFO != null);
            this.destinationsFO.addFileChangeListener((FileChangeListener)new MessageDestinationFileListener());
        }
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        return MessageDestinationSupport.getMessageDestinations(this.getMessageDestinationModel());
    }

    private static Set<MessageDestination> getMessageDestinations(Server server) throws ConfigurationException {
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<MessageDestination> hashSet = new HashSet<MessageDestination>();
        for (Mbean mbean : server.getMbean()) {
            int n;
            String string = mbean.getName();
            if (string == null) continue;
            MessageDestination.Type type = null;
            if (string.indexOf("service=Queue") > -1) {
                type = MessageDestination.Type.QUEUE;
            } else if (string.indexOf("service=Topic") > -1) {
                type = MessageDestination.Type.TOPIC;
            }
            if (type == null || (n = string.indexOf("name=")) == -1) continue;
            String string2 = string.substring(n + 5);
            if (string2.indexOf(",") > -1) {
                string2 = string2.substring(0, string2.indexOf(","));
            }
            hashSet.add(new JBossMessageDestination(string2, type));
        }
        return hashSet;
    }

    private synchronized Server getMessageDestinationModel() {
        block7: {
            try {
                if (this.destinationsFile.exists()) {
                    try {
                        if (this.destinationServiceModel == null) {
                            this.destinationServiceModel = Server.createGraph(this.destinationsFile);
                        }
                        break block7;
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                    break block7;
                }
                this.destinationServiceModel = new Server();
                ResourceConfigurationHelper.writeFile(this.destinationsFile, this.destinationServiceModel);
                this.ensureDestinationsFOExists();
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
                this.destinationServiceModel = null;
            }
        }
        return this.destinationServiceModel;
    }

    public MessageDestination createMessageDestination(String string, MessageDestination.Type type) throws UnsupportedOperationException, ConfigurationException {
        NotifyDescriptor.Confirmation confirmation;
        Object object;
        Object object2;
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
        }
        if (!this.destinationsFile.exists()) {
            this.getMessageDestinationModel();
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)this.destinationsFO);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return null;
        }
        Server server = null;
        StyledDocument styledDocument = null;
        try {
            object2 = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            styledDocument = object2.getDocument();
            if (styledDocument == null) {
                styledDocument = object2.openDocument();
            }
            object = styledDocument.getText(0, styledDocument.getLength()).getBytes();
            server = Server.createGraph(new ByteArrayInputStream((byte[])object));
        }
        catch (IOException iOException) {
            String string2 = NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_CannotUpdateFile", (Object)this.destinationsFile.getAbsolutePath());
            throw new ConfigurationException(string2, (Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.INFO, null, badLocationException);
        }
        catch (RuntimeException runtimeException) {
            object = this.getMessageDestinationModel();
            if (object == null) {
                throw new ConfigurationException(NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_msgdestXmlCannotParse", (Object)this.destinationsFile.getAbsolutePath()));
            }
            confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_msgdestXmlNotValid", (Object)this.destinationsFile.getAbsolutePath()), 2);
            Object object3 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object3 == NotifyDescriptor.CANCEL_OPTION) {
                return null;
            }
            server = object;
        }
        object2 = this.modifyMessageDestinationModel(server, string, type);
        boolean bl = dataObject.isModified();
        ResourceConfigurationHelper.replaceDocument(styledDocument, server);
        if (!bl) {
            confirmation = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            try {
                confirmation.save();
            }
            catch (IOException iOException) {
                String string3 = NbBundle.getMessage(MessageDestinationSupport.class, (String)"MSG_CannotSaveFile", (Object)this.destinationsFile.getAbsolutePath());
                throw new ConfigurationException(string3, (Throwable)iOException);
            }
        }
        this.destinationServiceModel = server;
        return object2;
    }

    private JBossMessageDestination modifyMessageDestinationModel(Server server, String string, MessageDestination.Type type) throws ConfigurationException {
        if (server == null) {
            return null;
        }
        for (MessageDestination object2 : MessageDestinationSupport.getMessageDestinations(server)) {
            if (!string.equals(object2.getName()) || type != object2.getType()) continue;
            return null;
        }
        Depends depends = new Depends();
        depends.setOptionalAttributeName("DestinationManager");
        Mbean mbean = new Mbean();
        if (type == MessageDestination.Type.QUEUE) {
            mbean.setCode("org.jboss.mq.server.jmx.Queue");
            mbean.setName("jboss.mq.destination:service=Queue,name=" + string);
        } else if (type == MessageDestination.Type.TOPIC) {
            mbean.setCode("org.jboss.mq.server.jmx.Topic");
            mbean.setName("jboss.mq.destination:service=Topic,name=" + string);
        }
        mbean.addDepends(depends);
        server.addMbean(mbean);
        return new JBossMessageDestination(string, type);
    }

    private class MessageDestinationFileListener
    extends FileChangeAdapter {
        private MessageDestinationFileListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            assert (fileEvent.getSource() == MessageDestinationSupport.this.destinationsFO);
            MessageDestinationSupport.this.destinationServiceModel = null;
        }

        public void fileDeleted(FileEvent fileEvent) {
            assert (fileEvent.getSource() == MessageDestinationSupport.this.destinationsFO);
            MessageDestinationSupport.this.destinationServiceModel = null;
        }
    }
}

