/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.jboss4.ide.ui.DomainComboModel;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginProperties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddServerPropertiesVisualPanel
extends JPanel {
    private final Set listeners = new HashSet();
    private JComboBox domainField;
    private JTextField domainPathField;
    private JLabel domainLabel;
    private JLabel domainPathLabel;
    private JLabel label1;
    private JPanel panel1;
    private JLabel hostLabel;
    private JTextField hostField;
    private JLabel portLabel;
    private JTextField portField;
    private JLabel userLabel;
    private JTextField userField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JComboBox serverType;

    public AddServerPropertiesVisualPanel() {
        this.init();
        this.setName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"TITLE_ServerProperties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    private void somethingChanged() {
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public boolean isLocalServer() {
        return this.serverType.getSelectedItem().equals("Local");
    }

    public String getHost() {
        return this.hostField.getText().trim();
    }

    public String getPort() {
        return this.portField.getText().trim();
    }

    public String getUser() {
        return this.userField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public String getDomainPath() {
        return this.domainPathField.getText();
    }

    public String getDomain() {
        return (String)this.domainField.getSelectedItem();
    }

    private void domainChanged() {
        DomainComboModel domainComboModel = (DomainComboModel)this.domainField.getModel();
        String string = domainComboModel.getCurrentPath();
        this.domainPathField.setText(string);
        this.portField.setText(JBPluginUtils.getHTTPConnectorPort(string));
        this.fireChangeEvent();
    }

    void installLocationChanged() {
        DomainComboModel domainComboModel = (DomainComboModel)this.domainField.getModel();
        String string = JBPluginProperties.getInstance().getInstallLocation();
        domainComboModel.setDomains(JBPluginUtils.getRegisteredDomains(string));
        this.domainChanged();
    }

    private void serverTypeChanged() {
        if (this.serverType.getSelectedItem().equals("Local")) {
            this.domainLabel.setVisible(true);
            this.domainField.setVisible(true);
            this.domainPathLabel.setVisible(true);
            this.domainPathField.setVisible(true);
            this.hostField.setEditable(false);
        } else {
            this.domainLabel.setVisible(false);
            this.domainField.setVisible(false);
            this.domainPathLabel.setVisible(false);
            this.domainPathField.setVisible(false);
            this.hostField.setEditable(true);
            this.portField.setEditable(true);
        }
        this.somethingChanged();
    }

    private void init() {
        this.label1 = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"TXT_PROPERTY_TEXT"));
        this.serverType = new JComboBox<String>(new String[]{"Local", "Remote"});
        this.serverType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerPropertiesVisualPanel.this.serverTypeChanged();
            }
        });
        this.domainPathLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DomainPath"));
        this.domainPathField = new JTextField();
        this.domainPathField.setColumns(20);
        this.domainPathField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DomainPath"));
        this.domainPathField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DomainPath"));
        this.panel1 = new JPanel();
        this.domainLabel = new JLabel();
        String string = JBPluginProperties.getInstance().getInstallLocation();
        this.domainField = new JComboBox(new DomainComboModel(JBPluginUtils.getRegisteredDomains(string)));
        this.domainField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Domain"));
        this.domainField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Domain"));
        this.domainField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddServerPropertiesVisualPanel.this.domainChanged();
            }
        });
        this.domainLabel.setLabelFor(this.domainField);
        Mnemonics.setLocalizedText((JLabel)this.domainLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Domain"));
        this.hostLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Host"));
        this.hostField = new JTextField();
        this.hostField.setColumns(20);
        this.hostField.setEditable(false);
        this.hostField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Host"));
        this.hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Host"));
        this.hostField.addKeyListener(new SomeChangesListener());
        this.hostLabel.setLabelFor(this.hostField);
        this.portLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Port"));
        this.portField = new JTextField();
        this.portField.setColumns(20);
        this.portField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Port"));
        this.portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Port"));
        this.portField.addKeyListener(new SomeChangesListener());
        this.portLabel.setLabelFor(this.portField);
        this.userLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_User"));
        this.userField = new JTextField();
        this.userField.addKeyListener(new SomeChangesListener());
        this.passwordLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Password"));
        this.passwordField = new JPasswordField();
        this.passwordField.addKeyListener(new SomeChangesListener());
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(280, 217));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.label1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.serverType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.domainLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.domainField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.domainPathLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.domainPathField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.hostLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.hostField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.portLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.portField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.userLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.userField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.passwordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 5);
        this.add((Component)this.passwordField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.domainPathField.setEnabled(false);
        this.portField.setEditable(false);
        this.userField.setVisible(false);
        this.userLabel.setVisible(false);
        this.passwordField.setVisible(false);
        this.passwordLabel.setVisible(false);
        this.serverType.setVisible(false);
        this.add((Component)this.panel1, gridBagConstraints);
        this.hostField.setText("localhost");
        this.portField.setText(JBPluginUtils.getHTTPConnectorPort(this.domainPathField.getText()));
        this.domainChanged();
    }

    private String browseDomainLocation() {
        String string = null;
        JFileChooser jFileChooser = this.getJFileChooser();
        int n = jFileChooser.showDialog(this, NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_ChooseButton"));
        if (n == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return string;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("LBL_Chooser_Name");
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new dirFilter());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setApproveButtonToolTipText("LBL_Chooser_Name");
        jFileChooser.getAccessibleContext().setAccessibleName("LBL_Chooser_Name");
        jFileChooser.getAccessibleContext().setAccessibleDescription("LBL_Chooser_Name");
        return jFileChooser;
    }

    private static class dirFilter
    extends FileFilter {
        private dirFilter() {
        }

        public boolean accept(File file) {
            return file.exists() && file.canRead() && file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DirType");
        }
    }

    class SomeChangesListener
    implements KeyListener {
        SomeChangesListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            AddServerPropertiesVisualPanel.this.somethingChanged();
        }
    }
}

