/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(JsEmbeddingProvider.class.getName());
    private static final String JSP_MIME_TYPE = "text/x-jsp";
    private static final String TAG_MIME_TYPE = "text/x-tag";
    private static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String PHP_MIME_TYPE = "text/x-php5";
    private static final Map<String, Translator> translators = new HashMap<String, Translator>();
    private static final String GENERATED_IDENTIFIER = " __UNKNOWN__ ";
    private static final String T_INLINE_HTML = "T_INLINE_HTML";
    private final String sourceMimeType;
    private final Translator translator;

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if (this.sourceMimeType.equals(snapshot.getMimeType())) {
            List<Embedding> list = this.translator.translate(snapshot);
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(list));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + this.sourceMimeType + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    public static boolean isGeneratedIdentifier(String string) {
        return GENERATED_IDENTIFIER.trim().equals(string);
    }

    private JsEmbeddingProvider(String string, Translator translator) {
        this.sourceMimeType = string;
        this.translator = translator;
    }

    private static void extractJavaScriptFromHtml(Snapshot snapshot, TokenSequence<? extends HTMLTokenId> tokenSequence, JsAnalyzerState jsAnalyzerState, List<Embedding> list) {
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            int n;
            Token token = tokenSequence.token();
            HTMLTokenId hTMLTokenId = (HTMLTokenId)token.id();
            if (hTMLTokenId == HTMLTokenId.SCRIPT) {
                int n2;
                jsAnalyzerState.in_javascript = true;
                int n3 = tokenSequence.offset();
                String string = ((Object)token.text()).toString();
                for (n2 = 0; n2 < string.length() && Character.isWhitespace((char)(n = string.charAt(n2))); ++n2) {
                }
                if (n2 < string.length() && string.startsWith("<!--", n2) && (n = string.indexOf(10, n2)) != -1) {
                    n3 += ++n;
                    string = string.substring(n);
                }
                list.add(snapshot.create(n3, string.length(), "text/javascript"));
                continue;
            }
            if (hTMLTokenId == HTMLTokenId.TAG_OPEN) {
                Object object;
                HTMLTokenId hTMLTokenId2;
                String string = ((Object)token.text()).toString();
                if (!"script".equals(string)) continue;
                TokenSequence tokenSequence2 = tokenSequence.subSequence(tokenSequence.offset());
                tokenSequence2.moveStart();
                boolean bl = false;
                n = 0;
                String string2 = null;
                String string3 = null;
                while (tokenSequence2.moveNext() && (hTMLTokenId2 = (HTMLTokenId)(object = tokenSequence2.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    if (bl || n != 0) {
                        if (hTMLTokenId2 == HTMLTokenId.ARGUMENT) break;
                        if (hTMLTokenId2 != HTMLTokenId.VALUE) continue;
                        if (bl) {
                            string3 = object.toString();
                        } else {
                            assert (n != 0);
                            string2 = object.toString();
                        }
                        bl = false;
                        n = 0;
                        continue;
                    }
                    if (hTMLTokenId2 != HTMLTokenId.ARGUMENT) continue;
                    String string4 = object.toString();
                    if ("src".equals(string4)) {
                        bl = true;
                        continue;
                    }
                    if (!"type".equals(string4)) continue;
                    n = 1;
                }
                if (string3 == null || string2 != null && string2.toLowerCase().indexOf("javascript") == -1) continue;
                if (string3.length() > 2 && string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if (string3.length() > 2 && string3.startsWith("'") && string3.endsWith("'")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                object = "__netbeans_import__('" + string3 + "');\n";
                list.add(snapshot.create((CharSequence)object, "text/javascript"));
                continue;
            }
            if (jsAnalyzerState.in_javascript && hTMLTokenId == HTMLTokenId.TEXT) {
                list.add(snapshot.create(tokenSequence.offset(), token.length(), "text/javascript"));
                continue;
            }
            if (hTMLTokenId == HTMLTokenId.VALUE_JAVASCRIPT) {
                int n4 = tokenSequence.offset();
                int n5 = n4 + tokenSequence.token().length();
                if (!jsAnalyzerState.in_inlined_javascript) {
                    String string = token.toString();
                    if (string.length() > 0 && ((n = (int)string.charAt(0)) == 39 || n == 34)) {
                        jsAnalyzerState.opening_quotation_stripped = true;
                        ++n4;
                    }
                    list.add(snapshot.create((CharSequence)";function(){\n", "text/javascript"));
                }
                jsAnalyzerState.in_inlined_javascript = true;
                jsAnalyzerState.lastInlinedJavascriptToken = tokenSequence.token();
                jsAnalyzerState.lastInlinedJavscriptEmbedding = snapshot.create(n4, n5 - n4, "text/javascript");
                list.add(jsAnalyzerState.lastInlinedJavscriptEmbedding);
                ++jsAnalyzerState.inlined_javascript_pieces;
                continue;
            }
            if (jsAnalyzerState.in_inlined_javascript && hTMLTokenId != HTMLTokenId.VALUE_JAVASCRIPT) {
                assert (jsAnalyzerState.lastInlinedJavscriptEmbedding != null);
                assert (jsAnalyzerState.lastInlinedJavascriptToken != null);
                int n6 = jsAnalyzerState.lastInlinedJavascriptToken.offset(snapshot.getTokenHierarchy());
                int n7 = jsAnalyzerState.lastInlinedJavascriptToken.length();
                CharSequence charSequence = jsAnalyzerState.lastInlinedJavascriptToken.text();
                if (jsAnalyzerState.opening_quotation_stripped && charSequence.length() > 0 && ((n = (int)charSequence.charAt(charSequence.length() - 1)) == 39 || n == 34)) {
                    --n7;
                    if (jsAnalyzerState.inlined_javascript_pieces == 1) {
                        ++n6;
                        --n7;
                    }
                    boolean bl = list.remove(jsAnalyzerState.lastInlinedJavscriptEmbedding);
                    assert (bl);
                    list.add(snapshot.create(n6, n7, "text/javascript"));
                }
                jsAnalyzerState.in_inlined_javascript = false;
                jsAnalyzerState.opening_quotation_stripped = false;
                jsAnalyzerState.lastInlinedJavascriptToken = null;
                jsAnalyzerState.lastInlinedJavscriptEmbedding = null;
                jsAnalyzerState.inlined_javascript_pieces = 0;
                list.add(snapshot.create((CharSequence)"\n}\n", "text/javascript"));
                continue;
            }
            if (hTMLTokenId == HTMLTokenId.TAG_CLOSE && "script".equals(token.toString())) {
                list.add(snapshot.create((CharSequence)"\n", "text/javascript"));
                continue;
            }
            jsAnalyzerState.in_javascript = false;
        }
    }

    static {
        translators.put(JSP_MIME_TYPE, new JspTranslator());
        translators.put(TAG_MIME_TYPE, new JspTranslator());
        translators.put(RHTML_MIME_TYPE, new RhtmlTranslator());
        translators.put(HTML_MIME_TYPE, new HtmlTranslator());
        translators.put(PHP_MIME_TYPE, new PhpTranslator());
    }

    private static final class JsAnalyzerState {
        int inlined_javascript_pieces = 0;
        boolean in_javascript = false;
        boolean in_inlined_javascript = false;
        boolean opening_quotation_stripped = false;
        Token lastInlinedJavascriptToken = null;
        Embedding lastInlinedJavscriptEmbedding = null;

        private JsAnalyzerState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HtmlTranslator
    implements Translator {
        private HtmlTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence();
            ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
            JsAnalyzerState jsAnalyzerState = new JsAnalyzerState();
            TokenSequence tokenSequence2 = tokenSequence;
            JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)tokenSequence2, jsAnalyzerState, arrayList);
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RhtmlTranslator
    implements Translator {
        private RhtmlTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
            TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
            if (tokenHierarchy == null) {
                LOG.info("Cannot get TokenHierarchy from snapshot " + snapshot);
                return arrayList;
            }
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            JsAnalyzerState jsAnalyzerState = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().primaryCategory().equals("html")) {
                    TokenSequence tokenSequence2 = tokenSequence.embedded(HTMLTokenId.language());
                    if (tokenSequence2 == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)tokenSequence2, jsAnalyzerState, arrayList);
                    continue;
                }
                if (!token.id().primaryCategory().equals("ruby") || !jsAnalyzerState.in_inlined_javascript && !jsAnalyzerState.in_javascript) continue;
                int n = tokenSequence.offset();
                int n2 = n + token.length();
                arrayList.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, "text/javascript"));
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PhpTranslator
    implements Translator {
        private PhpTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence();
            ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
            JsAnalyzerState jsAnalyzerState = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                boolean bl;
                Token token = tokenSequence.token();
                if (token.id().name().equals(JsEmbeddingProvider.T_INLINE_HTML)) {
                    TokenSequence tokenSequence2 = tokenSequence.embedded(HTMLTokenId.language());
                    if (tokenSequence2 == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)tokenSequence2, jsAnalyzerState, arrayList);
                }
                if (!jsAnalyzerState.in_inlined_javascript && !jsAnalyzerState.in_javascript) continue;
                boolean bl2 = false;
                while ((bl = tokenSequence.moveNext()) && !tokenSequence.token().id().name().equals(JsEmbeddingProvider.T_INLINE_HTML)) {
                    bl2 = true;
                }
                if (bl) {
                    tokenSequence.movePrevious();
                }
                if (!bl2) continue;
                arrayList.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, "text/javascript"));
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JspTranslator
    implements Translator {
        private JspTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
            if (tokenHierarchy == null) {
                return Collections.emptyList();
            }
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
            JsAnalyzerState jsAnalyzerState = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().primaryCategory().equals("text")) {
                    TokenSequence tokenSequence2 = tokenSequence.embedded(HTMLTokenId.language());
                    if (tokenSequence2 == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)tokenSequence2, jsAnalyzerState, arrayList);
                    continue;
                }
                if (!token.id().primaryCategory().equals("expression-language") && !token.id().primaryCategory().equals("scriptlet") && (!token.id().primaryCategory().equals("symbol") || !"/>".equals(((Object)token.text()).toString())) || !jsAnalyzerState.in_inlined_javascript && !jsAnalyzerState.in_javascript) continue;
                arrayList.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, "text/javascript"));
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Translator {
        public List<Embedding> translate(Snapshot var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (snapshot.getMimeType().equals(JsEmbeddingProvider.HTML_MIME_TYPE) && snapshot.getMimePath().size() > 1) {
                return null;
            }
            Translator translator = (Translator)translators.get(snapshot.getMimeType());
            if (translator != null) {
                return Collections.singleton(new JsEmbeddingProvider(snapshot.getMimeType(), translator));
            }
            return Collections.emptyList();
        }
    }
}

