/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TreeModelRoot
implements ModelListener {
    static final long serialVersionUID = -1259352660663524178L;
    private Models.CompoundModel model;
    private TreeModelNode rootNode;
    private WeakHashMap<Object, WeakReference<TreeModelNode>> objectToNode = new WeakHashMap();
    private DefaultTreeFeatures treeFeatures;
    private TreeModelNode.LazyEvaluator childrenEvaluator;
    private TreeModelNode.LazyEvaluator valuesEvaluator;
    private RequestProcessor rp;

    public TreeModelRoot(Models.CompoundModel compoundModel, TreeView treeView) {
        this.model = compoundModel;
        this.treeFeatures = new DefaultTreeFeatures(treeView);
        this.getRP();
        compoundModel.addModelListener(this);
    }

    public TreeModelRoot(Models.CompoundModel compoundModel, OutlineView outlineView) {
        this.model = compoundModel;
        this.treeFeatures = new DefaultTreeFeatures(outlineView);
        this.getRP();
        compoundModel.addModelListener(this);
    }

    private void getRP() {
        try {
            Field field = this.model.getClass().getDeclaredField("rp");
            field.setAccessible(true);
            this.rp = (RequestProcessor)field.get(this.model);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    public Models.TreeFeatures getTreeFeatures() {
        return this.treeFeatures;
    }

    public TreeModelNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = new TreeModelNode(this.model, this, this.model.getRoot());
        }
        return this.rootNode;
    }

    void registerNode(Object object, TreeModelNode treeModelNode) {
        this.objectToNode.put(object, new WeakReference<TreeModelNode>(treeModelNode));
    }

    TreeModelNode findNode(Object object) {
        WeakReference<TreeModelNode> weakReference = this.objectToNode.get(object);
        if (weakReference == null) {
            return null;
        }
        return (TreeModelNode)((Object)weakReference.get());
    }

    public void modelChanged(final ModelEvent modelEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModelEvent modelEvent2;
                Object object;
                if (TreeModelRoot.this.model == null) {
                    return;
                }
                if (modelEvent instanceof ModelEvent.TableValueChanged && (object = ((ModelEvent.TableValueChanged)(modelEvent2 = (ModelEvent.TableValueChanged)modelEvent)).getNode()) != null) {
                    TreeModelNode treeModelNode = TreeModelRoot.this.findNode(object);
                    if (treeModelNode != null) {
                        String string = ((ModelEvent.TableValueChanged)modelEvent2).getColumnID();
                        if (string != null) {
                            treeModelNode.refreshColumn(string);
                        } else {
                            treeModelNode.refresh();
                        }
                    }
                    return;
                }
                if (modelEvent instanceof ModelEvent.NodeChanged && (object = ((ModelEvent.NodeChanged)(modelEvent2 = (ModelEvent.NodeChanged)modelEvent)).getNode()) != null) {
                    TreeModelNode treeModelNode = TreeModelRoot.this.findNode(object);
                    if (treeModelNode != null) {
                        treeModelNode.refresh(((ModelEvent.NodeChanged)modelEvent2).getChange());
                    }
                    return;
                }
                TreeModelRoot.this.rootNode.setObject(TreeModelRoot.this.model.getRoot());
            }
        });
    }

    synchronized TreeModelNode.LazyEvaluator getChildrenEvaluator() {
        if (this.childrenEvaluator == null) {
            this.childrenEvaluator = new TreeModelNode.LazyEvaluator(this.rp);
        }
        return this.childrenEvaluator;
    }

    synchronized TreeModelNode.LazyEvaluator getValuesEvaluator() {
        if (this.valuesEvaluator == null) {
            this.valuesEvaluator = new TreeModelNode.LazyEvaluator(this.rp);
        }
        return this.valuesEvaluator;
    }

    public synchronized void destroy() {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.treeFeatures.destroy();
            this.treeFeatures = null;
        }
        this.model = null;
        this.objectToNode = new WeakHashMap();
    }

    public synchronized Models.CompoundModel getModel() {
        return this.model;
    }

    private final class DefaultTreeFeatures
    extends Models.TreeFeatures
    implements TreeExpansionListener {
        private TreeView view;
        private OutlineView outline;

        private DefaultTreeFeatures(TreeView treeView) {
            JTree jTree;
            this.view = treeView;
            try {
                Field field = TreeView.class.getDeclaredField("tree");
                field.setAccessible(true);
                jTree = (JTree)field.get(treeView);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return;
            }
            jTree.addTreeExpansionListener(this);
        }

        private DefaultTreeFeatures(OutlineView outlineView) {
            this.outline = outlineView;
            outlineView.addTreeExpansionListener((TreeExpansionListener)this);
        }

        public void destroy() {
            if (this.outline != null) {
                this.outline.removeTreeExpansionListener((TreeExpansionListener)this);
            } else {
                JTree jTree;
                try {
                    Field field = TreeView.class.getDeclaredField("tree");
                    field.setAccessible(true);
                    jTree = (JTree)field.get(this.view);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    return;
                }
                jTree.removeTreeExpansionListener(this);
            }
        }

        public boolean isExpanded(Object object) {
            TreeModelNode treeModelNode = TreeModelRoot.this.findNode(object);
            if (treeModelNode == null) {
                return false;
            }
            if (this.outline != null) {
                return this.outline.isExpanded((Node)treeModelNode);
            }
            return this.view.isExpanded((Node)treeModelNode);
        }

        public void expandNode(Object object) {
            TreeModelNode treeModelNode = TreeModelRoot.this.findNode(object);
            if (treeModelNode != null) {
                if (this.outline != null) {
                    this.outline.expandNode((Node)treeModelNode);
                } else {
                    this.view.expandNode((Node)treeModelNode);
                }
            }
        }

        public void collapseNode(Object object) {
            TreeModelNode treeModelNode = TreeModelRoot.this.findNode(object);
            if (treeModelNode != null) {
                if (this.outline != null) {
                    this.outline.collapseNode((Node)treeModelNode);
                } else {
                    this.view.collapseNode((Node)treeModelNode);
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Models.CompoundModel compoundModel = TreeModelRoot.this.getModel();
            if (compoundModel != null) {
                compoundModel.nodeExpanded(this.initExpandCollapseNotify(treeExpansionEvent));
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            Models.CompoundModel compoundModel = TreeModelRoot.this.getModel();
            if (compoundModel != null) {
                compoundModel.nodeCollapsed(this.initExpandCollapseNotify(treeExpansionEvent));
            }
        }

        private Object initExpandCollapseNotify(TreeExpansionEvent treeExpansionEvent) {
            Object object;
            Node node = Visualizer.findNode((Object)treeExpansionEvent.getPath().getLastPathComponent());
            Object object2 = node.getLookup().lookup(Object.class);
            Integer n = (node = node.getParentNode()) == null ? new Integer(0) : ((object = node.getChildren()) instanceof TreeModelNode.TreeModelChildren ? ((TreeModelNode.TreeModelChildren)object).getTreeDepth() : object);
            object = TreeModelRoot.this.getModel();
            if (object != null) {
                DefaultTreeExpansionManager.get((Models.CompoundModel)object).setChildrenToActOn(n);
            }
            return object2;
        }
    }
}

