/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestsuiteNode
extends AbstractNode {
    private static final int MAX_TOOLTIP_LINES = Integer.getInteger("testrunner.max.tooltip.lines", 4);
    private static final int MAX_TOOLTIP_LINE_LENGTH = Integer.getInteger("testrunner.max.tooltip.line.length", 80);
    static final boolean DISPLAY_TOOLTIPS = Boolean.valueOf(System.getProperty("testrunner.display.tooltips", "true"));
    protected String suiteName;
    protected TestSuite suite;
    protected Report report;
    protected boolean filtered;

    public TestsuiteNode(String string, boolean bl) {
        this(null, string, bl, null);
    }

    public TestsuiteNode(Report report, boolean bl) {
        this(report, null, bl, null);
    }

    protected TestsuiteNode(Report report, String string, boolean bl, Lookup lookup) {
        super((Children)(report != null ? new TestsuiteNodeChildren(report, bl) : Children.LEAF), lookup);
        this.report = report;
        this.suiteName = report != null ? report.getSuiteClassName() : string;
        this.filtered = bl;
        assert (this.suiteName != null);
        this.setDisplayName();
    }

    static String toTooltipText(List<OutputLine> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        if (list.isEmpty()) {
            stringBuilder.append("<i>" + NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_NoOutput") + "</i>");
        } else {
            for (int i = 0; i < list.size(); ++i) {
                if (i >= MAX_TOOLTIP_LINES) {
                    stringBuilder.append("<br><i>" + NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_MoreOutput", (Object)(list.size() - i)) + "</i>");
                    break;
                }
                String string = list.get(i).getLine();
                int n = string.length();
                if (n > MAX_TOOLTIP_LINE_LENGTH) {
                    string = string.substring(0, MAX_TOOLTIP_LINE_LENGTH);
                    string = string.concat("<i> " + NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_CharsOmitted", (Object)(n - MAX_TOOLTIP_LINE_LENGTH)) + "</i>");
                }
                stringBuilder.append(string);
                if (i >= list.size()) continue;
                stringBuilder.append("<br>");
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Image getIcon(int n) {
        if (this.report != null) {
            Status status = this.report.getStatus();
            if (!this.report.completed) {
                switch (status) {
                    case FAILED: 
                    case ERROR: {
                        return ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/run.gif"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error-badge.gif"), (int)8, (int)8);
                    }
                }
            } else {
                switch (status) {
                    case ABORTED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning_16.png");
                    }
                    case PENDING: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning2_16.png");
                    }
                    case PASSED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_16.png");
                    }
                    case FAILED: 
                    case ERROR: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error_16.png");
                    }
                }
            }
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/run.gif");
    }

    public void displayReport(Report report) {
        assert (report != null);
        assert (report.getSuiteClassName().equals(this.suiteName) || this.suiteName == TestSuite.ANONYMOUS_SUITE);
        this.report = report;
        this.suiteName = report.getSuiteClassName();
        this.setDisplayName();
        Children children = this.getChildren();
        if (children instanceof TestsuiteNodeChildren) {
            ((TestsuiteNodeChildren)children).addNotify();
        } else {
            this.setChildren((Children)new TestsuiteNodeChildren(report, this.filtered));
        }
        if (DISPLAY_TOOLTIPS) {
            this.setShortDescription(TestsuiteNode.toTooltipText(this.getOutput()));
        }
        this.fireIconChange();
    }

    public Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        String string;
        if (this.report == null) {
            string = this.suiteName != TestSuite.ANONYMOUS_SUITE ? NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunning", (Object)this.suiteName) : NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunningNoname");
        } else if (this.report.isAborted()) {
            string = NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteAborted", (Object)this.suiteName);
        } else if (!this.report.completed) {
            boolean bl = this.containsFailed();
            string = bl ? NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName;
            string = NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunning", (Object)string);
        } else {
            boolean bl = this.containsFailed();
            string = bl ? NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName;
        }
        this.setDisplayName(string);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.suiteName != TestSuite.ANONYMOUS_SUITE) {
            stringBuffer.append(this.suiteName);
        } else {
            stringBuffer.append(NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteNoname"));
        }
        if (this.report != null) {
            Status status = this.report.getStatus();
            stringBuffer.append("&nbsp;&nbsp;");
            stringBuffer.append("<font color='#");
            stringBuffer.append(status.getHtmlDisplayColor() + "'>");
            stringBuffer.append(TestsuiteNode.suiteStatusToMsg(status, true));
            stringBuffer.append("</font>");
        }
        if (this.report == null || !this.report.completed) {
            stringBuffer.append("&nbsp;&nbsp;");
            stringBuffer.append(NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunning_HTML"));
        }
        return stringBuffer.toString();
    }

    static String suiteStatusToMsg(Status status, boolean bl) {
        String string = null;
        string = Status.ABORTED == status ? "MSG_TestsuiteAborted" : (Status.ERROR == status || Status.FAILED == status ? "MSG_TestsuiteFailed" : (Status.PENDING == status ? "MSG_TestsuitePending" : "MSG_TestsuitePassed"));
        string = bl ? string + "_HTML" : string;
        return NbBundle.getMessage(TestsuiteNode.class, (String)string);
    }

    void setSuite(TestSuite testSuite) {
        this.suite = testSuite;
    }

    public TestSuite getSuite() {
        return this.suite;
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((TestsuiteNodeChildren)children).setFiltered(bl);
        }
    }

    private boolean containsFailed() {
        return this.report != null && this.report.getFailures() + this.report.getErrors() != 0;
    }

    public Action getPreferredAction() {
        return null;
    }

    public Action[] getActions(boolean bl) {
        return new Action[0];
    }

    private List<OutputLine> getOutput() {
        ArrayList<OutputLine> arrayList = new ArrayList<OutputLine>();
        for (Testcase testcase : this.report.getTests()) {
            arrayList.addAll(testcase.getOutput());
        }
        return arrayList;
    }
}

