/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter;

import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.Invocation;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.XmlStreamWriterMethodType;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public final class XmlFilteringUtils {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(XmlFilteringUtils.class);

    private XmlFilteringUtils() {
    }

    public static String getDefaultNamespaceURI(XMLStreamWriter writer) {
        return writer.getNamespaceContext().getNamespaceURI("");
    }

    public static QName getElementNameToWrite(Invocation invocation, String defaultNamespaceURI) {
        String localName;
        String namespaceURI;
        XmlFilteringUtils.checkInvocationParameter(invocation, XmlStreamWriterMethodType.WRITE_START_ELEMENT);
        int argumentsCount = invocation.getArgumentsCount();
        switch (argumentsCount) {
            case 1: {
                namespaceURI = defaultNamespaceURI;
                localName = invocation.getArgument(0).toString();
                break;
            }
            case 2: {
                namespaceURI = invocation.getArgument(0).toString();
                localName = invocation.getArgument(1).toString();
                break;
            }
            case 3: {
                localName = invocation.getArgument(1).toString();
                namespaceURI = invocation.getArgument(2).toString();
                break;
            }
            default: {
                throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_1009_UNEXPECTED_ARGUMENTS_COUNT((Object)((Object)XmlStreamWriterMethodType.WRITE_START_ELEMENT) + "(...)", argumentsCount)));
            }
        }
        return new QName(namespaceURI, localName);
    }

    public static AttributeInfo getAttributeNameToWrite(Invocation invocation, String defaultNamespaceURI) {
        String value;
        String localName;
        String namespaceURI;
        XmlFilteringUtils.checkInvocationParameter(invocation, XmlStreamWriterMethodType.WRITE_ATTRIBUTE);
        int argumentsCount = invocation.getArgumentsCount();
        switch (argumentsCount) {
            case 2: {
                namespaceURI = defaultNamespaceURI;
                localName = invocation.getArgument(0).toString();
                value = invocation.getArgument(1).toString();
                break;
            }
            case 3: {
                namespaceURI = invocation.getArgument(0).toString();
                localName = invocation.getArgument(1).toString();
                value = invocation.getArgument(2).toString();
                break;
            }
            case 4: {
                namespaceURI = invocation.getArgument(1).toString();
                localName = invocation.getArgument(2).toString();
                value = invocation.getArgument(3).toString();
                break;
            }
            default: {
                throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_1009_UNEXPECTED_ARGUMENTS_COUNT((Object)((Object)XmlStreamWriterMethodType.WRITE_ATTRIBUTE) + "(...)", argumentsCount)));
            }
        }
        return new AttributeInfo(new QName(namespaceURI, localName), value);
    }

    private static void checkInvocationParameter(Invocation invocation, XmlStreamWriterMethodType expectedType) {
        if (invocation == null) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_1038_METHOD_PARAMETER_CANNOT_BE_NULL("Invocation parameter")));
        }
        if (invocation.getMethodType() != expectedType) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_1039_ILLEGAL_INVOCATION_METHOD_TYPE((Object)invocation.getMethodType(), (Object)expectedType)));
        }
    }

    public static final class AttributeInfo {
        private final QName name;
        private final String value;

        AttributeInfo(QName name, String value) {
            this.name = name;
            this.value = value;
        }

        public QName getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

