/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rm.localization.RmLogger;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

final class PeriodicFiberResumeTask
implements Runnable {
    private static final RmLogger LOGGER = RmLogger.getLogger(PeriodicFiberResumeTask.class);
    private final Queue<FiberRegistration> fiberResumeQueue = new ConcurrentLinkedQueue<FiberRegistration>();
    private long resumePeriod;

    PeriodicFiberResumeTask(long period) {
        this.resumePeriod = period;
    }

    public void run() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Periodic fiber task executed - resume queue size: [ %d ]", this.fiberResumeQueue.size()));
        }
        while (!this.fiberResumeQueue.isEmpty() && this.fiberResumeQueue.peek().expired(this.resumePeriod)) {
            FiberRegistration registration = this.fiberResumeQueue.poll();
            registration.fiber.resume(registration.packet);
            if (!LOGGER.isLoggable(Level.FINER)) continue;
            LOGGER.finer(String.format("Fiber %s resumed with packet%n%s", registration.fiber, registration.packet));
        }
    }

    final boolean registerForResume(@NotNull Fiber fiber, Packet packet) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Fiber %s registered for resume with packet%n%s", fiber, packet));
        }
        return this.fiberResumeQueue.offer(new FiberRegistration(fiber, packet));
    }

    private static class FiberRegistration {
        private final long timestamp = System.currentTimeMillis();
        @NotNull
        final Fiber fiber;
        final Packet packet;

        FiberRegistration(Fiber fiber, Packet packet) {
            this.fiber = fiber;
            this.packet = packet;
        }

        boolean expired(long period) {
            return System.currentTimeMillis() - this.timestamp >= period;
        }
    }
}

