/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.assembler.TubeAppender;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.runtime.AbstractRmServerTube;
import com.sun.xml.ws.rm.runtime.RmClientTube;
import javax.xml.ws.WebServiceException;

public class RmTubeAppender
implements TubeAppender {
    public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
        if (this.isReliableMessagingEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            return new RmClientTube(context);
        }
        return context.getTubelineHead();
    }

    public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
        if (this.isReliableMessagingEnabled(context.getPolicyMap(), context.getWsdlPort())) {
            return AbstractRmServerTube.getInstance(context);
        }
        return context.getTubelineHead();
    }

    private boolean isReliableMessagingEnabled(PolicyMap policyMap, WSDLPort port) throws WebServiceException {
        if (policyMap == null || port == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            if (policy == null) {
                return false;
            }
            return policy.contains(RmVersion.WSRM10.policyNamespaceUri) || policy.contains(RmVersion.WSRM11.policyNamespaceUri);
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

