/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.testing;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.PacketAdapter;

public abstract class PacketFilter {
    protected static final long UNSPECIFIED = -1L;
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketFilter.class);
    private Configuration rmConfiguration;

    protected PacketFilter(RmVersion rmVersion) {
    }

    protected PacketFilter() {
    }

    public abstract Packet filterClientRequest(Packet var1) throws Exception;

    public abstract Packet filterServerResponse(Packet var1) throws Exception;

    protected final String getSequenceId(Packet packet) {
        try {
            if (this.rmConfiguration == null || packet == null || packet.getMessage() == null || packet.getMessage().getHeaders() == null) {
                return null;
            }
            PacketAdapter pa = PacketAdapter.getInstance(this.rmConfiguration, packet);
            return pa.getSequenceId();
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return null;
        }
    }

    protected final long getMessageId(Packet packet) {
        try {
            if (this.rmConfiguration == null || packet == null || packet.getMessage() == null || packet.getMessage().getHeaders() == null) {
                return -1L;
            }
            PacketAdapter pa = PacketAdapter.getInstance(this.rmConfiguration, packet);
            return pa.getMessageNumber();
        }
        catch (Exception ex) {
            LOGGER.warning("Unexpected exception occured", ex);
            return -1L;
        }
    }

    protected final RmVersion getRmVersion() {
        return this.rmConfiguration != null ? this.rmConfiguration.getRmVersion() : null;
    }

    final void configure(Configuration configuration) {
        this.rmConfiguration = configuration;
    }
}

