/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.config;

import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.SecurityPolicyContainer;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Logger;

public class ApplicationSecurityConfiguration
extends SecurityPolicyContainer {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    boolean bsp = false;
    boolean useCacheFlag = false;
    String envHandlerClassName = null;
    boolean optimize = false;
    private boolean retainSecHeader = false;
    private Hashtable augmentedCtx2PolicyMap = new Hashtable();
    private SecurityPolicy configForSingleServiceNoPorts = null;
    private boolean sSNP = false;
    private boolean hasOps = true;
    private Collection allReceiverPolicies = null;
    private ArrayList servicesList = new ArrayList();

    public ApplicationSecurityConfiguration() {
    }

    public ApplicationSecurityConfiguration(String handlerClassName) {
        this.envHandlerClassName = handlerClassName;
    }

    public void setSecurityEnvironmentHandler(String handlerClassName) {
        this.envHandlerClassName = handlerClassName;
    }

    public String getSecurityEnvironmentHandler() {
        return this.envHandlerClassName;
    }

    public Collection getAllTopLevelApplicationSecurityConfigurations() {
        return this.servicesList;
    }

    public Collection getAllPolicies() {
        Collection c = this._ctx2PolicyMap.values();
        ArrayList<SecurityPolicy> d = new ArrayList<SecurityPolicy>();
        for (ArrayList list : c) {
            for (int i = 0; i < list.size(); ++i) {
                SecurityPolicy policy = (SecurityPolicy)list.get(i);
                if (PolicyTypeUtil.applicationSecurityConfiguration(policy)) {
                    d.addAll(((ApplicationSecurityConfiguration)policy).getAllPolicies());
                    continue;
                }
                d.add(policy);
            }
        }
        return d;
    }

    public Collection getAllSenderPolicies() {
        Collection c = this._ctx2PolicyMap.values();
        ArrayList<MessagePolicy> d = new ArrayList<MessagePolicy>();
        for (ArrayList list : c) {
            for (int i = 0; i < list.size(); ++i) {
                SecurityPolicy policy = (SecurityPolicy)list.get(i);
                if (PolicyTypeUtil.applicationSecurityConfiguration(policy)) {
                    d.addAll(((ApplicationSecurityConfiguration)policy).getAllSenderPolicies());
                    continue;
                }
                DeclarativeSecurityConfiguration dsc = (DeclarativeSecurityConfiguration)policy;
                MessagePolicy mp = dsc.senderSettings();
                d.add(mp);
            }
        }
        return d;
    }

    public Collection getAllReceiverPolicies() {
        if (this.allReceiverPolicies != null) {
            return this.allReceiverPolicies;
        }
        Collection c = this._ctx2PolicyMap.values();
        ArrayList<SecurityPolicy> d = new ArrayList<SecurityPolicy>();
        for (ArrayList list : c) {
            for (int i = 0; i < list.size(); ++i) {
                SecurityPolicy policy = (SecurityPolicy)list.get(i);
                if (PolicyTypeUtil.applicationSecurityConfiguration(policy)) {
                    d.addAll(((ApplicationSecurityConfiguration)policy).getAllReceiverPolicies());
                    continue;
                }
                if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
                    DeclarativeSecurityConfiguration dsc = (DeclarativeSecurityConfiguration)policy;
                    MessagePolicy mp = dsc.receiverSettings();
                    if (!(mp.getPrimaryPolicies().size() == 0 && mp.getSecondaryPolicies().size() == 0 || mp.getPrimaryPolicies().size() != 0 && mp.getSecondaryPolicies().size() == 0) && (mp.getPrimaryPolicies().size() == 0 || mp.getSecondaryPolicies().size() == 0)) continue;
                    d.add(mp);
                    continue;
                }
                d.add(policy);
            }
        }
        return d;
    }

    public boolean isEmpty() {
        return this._ctx2PolicyMap.isEmpty();
    }

    public boolean isBSP() {
        return this.bsp;
    }

    public void isBSP(boolean flag) {
        this.bsp = flag;
    }

    public boolean useCache() {
        return this.useCacheFlag;
    }

    public void useCache(boolean flag) {
        this.useCacheFlag = flag;
    }

    public boolean retainSecurityHeader() {
        return this.retainSecHeader;
    }

    public void retainSecurityHeader(boolean arg) {
        this.retainSecHeader = arg;
    }

    public SecurityPolicy getSecurityConfiguration(StaticApplicationContext context) {
        if (this.configForSingleServiceNoPorts != null) {
            return this.configForSingleServiceNoPorts;
        }
        SecurityPolicy sp = (SecurityPolicy)this.augmentedCtx2PolicyMap.get(context);
        if (sp != null) {
            return sp;
        }
        sp = this.getDSCORDSP((ArrayList)this._ctx2PolicyMap.get(context));
        if (sp != null) {
            this.augmentedCtx2PolicyMap.put(context, sp);
            return sp;
        }
        StaticApplicationContext ctx = new StaticApplicationContext(context);
        if (ctx.isOperation()) {
            ctx.setOperationIdentifier("");
            sp = this.getDSCORDSP((ArrayList)this._ctx2PolicyMap.get(ctx));
            if (sp == null) {
                ctx.setPortIdentifier("");
                sp = this.getDSCORDSP((ArrayList)this._ctx2PolicyMap.get(ctx));
            }
        } else if (ctx.isPort()) {
            ctx.setPortIdentifier("");
            sp = this.getDSCORDSP((ArrayList)this._ctx2PolicyMap.get(ctx));
        }
        if (context != null && sp != null) {
            this.augmentedCtx2PolicyMap.put(context, sp);
        }
        return sp;
    }

    public boolean hasOperationPolicies() {
        return this.hasOps;
    }

    public void hasOperationPolicies(boolean flag) {
        this.hasOps = flag;
    }

    public void singleServiceNoPorts(boolean flag) {
        this.sSNP = flag;
    }

    private boolean singleServiceNoPorts() {
        return this.sSNP;
    }

    private SecurityPolicy getDSCORDSP(ArrayList list) {
        if (list == null) {
            return null;
        }
        for (SecurityPolicy policy : list) {
            if (!PolicyTypeUtil.applicationSecurityConfiguration(policy)) continue;
            return ((ApplicationSecurityConfiguration)policy).getDSCORDSP();
        }
        return null;
    }

    private SecurityPolicy getDSCORDSP() {
        Collection c = this._ctx2PolicyMap.values();
        for (ArrayList al : c) {
            SecurityPolicy policy = (SecurityPolicy)al.iterator().next();
            if (!PolicyTypeUtil.declarativeSecurityConfiguration(policy) && !PolicyTypeUtil.dynamicSecurityPolicy(policy)) continue;
            return policy;
        }
        return null;
    }

    public String getType() {
        return "ApplicationSecurityConfiguration";
    }

    public void init() {
        this.setConfigForSingleServiceNoPorts();
        this.allReceiverPolicies = this.getAllReceiverPoliciesFromConfig();
    }

    public void setSecurityPolicy(StaticPolicyContext ctx, SecurityPolicy policy) {
        if (ctx instanceof StaticApplicationContext && ((StaticApplicationContext)ctx).isService() && PolicyTypeUtil.applicationSecurityConfiguration(policy)) {
            this.servicesList.add(policy);
        }
        super.setSecurityPolicy(ctx, policy);
    }

    private Collection getAllReceiverPoliciesFromConfig() {
        ArrayList d = new ArrayList();
        for (int i = 0; i < this.servicesList.size(); ++i) {
            ApplicationSecurityConfiguration policy = (ApplicationSecurityConfiguration)this.servicesList.get(i);
            d.addAll(policy.getAllReceiverPolicies());
        }
        return d;
    }

    private void setConfigForSingleServiceNoPorts() {
        if (this.singleServiceNoPorts()) {
            Collection c = this._ctx2PolicyMap.values();
            ArrayList al = (ArrayList)c.iterator().next();
            ApplicationSecurityConfiguration serviceConfig = (ApplicationSecurityConfiguration)al.iterator().next();
            this.configForSingleServiceNoPorts = serviceConfig.getDSCORDSP();
        }
    }

    public void isOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    public boolean isOptimized() {
        return this.optimize;
    }
}

