/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.assistance;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.asm.core.assistance.LiveRangesAccessor;
import org.netbeans.modules.asm.model.AsmState;
import org.netbeans.modules.asm.model.lang.AsmElement;
import org.netbeans.modules.asm.model.lang.InstructionElement;
import org.netbeans.modules.asm.model.lang.Register;
import org.netbeans.modules.asm.model.lang.syntax.FunctionBoundsResolver;
import org.netbeans.modules.asm.model.util.AsmModelUtilities;
import org.netbeans.modules.asm.model.util.IntervalSet;

public class LiveRangesAction {
    public LiveRangesAccessor calculateRanges(AsmState asmState) {
        AsmElement asmElement = asmState.getElements();
        FunctionBoundsResolver functionBoundsResolver = (FunctionBoundsResolver)asmState.getServices().lookup(FunctionBoundsResolver.class);
        if (functionBoundsResolver == null) {
            return null;
        }
        IntervalSet<FunctionBoundsResolver.Entry> intervalSet = functionBoundsResolver.getFunctions();
        LivaRangesAccessorImpl livaRangesAccessorImpl = new LivaRangesAccessorImpl(asmState);
        for (FunctionBoundsResolver.Entry entry : intervalSet) {
            this.calculateRanges(asmElement, livaRangesAccessorImpl, entry.getStartOffset(), entry.getEndOffset());
        }
        return livaRangesAccessorImpl;
    }

    private void calculateRanges(AsmElement asmElement, LivaRangesAccessorImpl livaRangesAccessorImpl, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        List<AsmElement> list = asmElement.getCompounds();
        HashMap<Register, Integer> hashMap = new HashMap<Register, Integer>();
        HashMap<Register, Integer> hashMap2 = new HashMap<Register, Integer>();
        for (int i = n; i < n2; ++i) {
            Register register;
            AsmElement object4 = list.get(i);
            if (!(object4 instanceof InstructionElement)) continue;
            object3 = (InstructionElement)object4;
            object2 = AsmModelUtilities.getRegistersClosure(object3.getReadRegs());
            object = AsmModelUtilities.getRegistersClosure(object3.getWriteRegs());
            Iterator<Register> iterator = object2.iterator();
            while (iterator.hasNext()) {
                register = iterator.next();
                hashMap2.put(register, i);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                register = iterator.next();
                Integer n3 = (Integer)hashMap.get(register);
                Integer n4 = (Integer)hashMap2.get(register);
                if (n3 == null && n4 != null) {
                    livaRangesAccessorImpl.addRange(register, n, n4);
                } else if (n3 != null && n4 != null && n4 > n3) {
                    livaRangesAccessorImpl.addRange(register, n3, n4);
                }
                hashMap.put(register, i);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object3 = (Register)entry.getKey();
            object2 = (Integer)hashMap2.get(object3);
            object = (Integer)entry.getValue();
            if (object == null || object2 != null && (Integer)object2 >= (Integer)object) continue;
            livaRangesAccessorImpl.addRange((Register)object3, (Integer)object, n2 - 1);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            object3 = (Register)entry.getKey();
            object2 = (Integer)entry.getValue();
            object = (Integer)hashMap.get(object3);
            if (object == null && object2 != null) {
                livaRangesAccessorImpl.addRange((Register)object3, n, (Integer)object2);
                continue;
            }
            if (object == null || object2 == null || (Integer)object2 <= (Integer)object) continue;
            livaRangesAccessorImpl.addRange((Register)object3, (Integer)object, (Integer)object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LivaRangesAccessorImpl
    implements LiveRangesAccessor {
        private Map<Register, List<Integer>> ranges;
        private AsmState state;

        public LivaRangesAccessorImpl(AsmState asmState) {
            this.state = asmState;
            this.ranges = new HashMap<Register, List<Integer>>();
        }

        public void addRange(Register register, int n, int n2) {
            List<Integer> list = this.ranges.get(register);
            if (list == null) {
                list = new LinkedList<Integer>();
                this.ranges.put(register, list);
            }
            list.add(n);
            list.add(n2);
        }

        @Override
        public AsmState getState() {
            return this.state;
        }

        @Override
        public List<Integer> getRangesForRegister(Register register) {
            List<Integer> list = this.ranges.get(register);
            if (list == null || list.size() == 0) {
                return Collections.emptyList();
            }
            return list;
        }
    }
}

