/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.assistance;

import java.awt.Color;
import java.util.Iterator;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.asm.core.assistance.RegisterHighlightAction;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.core.ui.top.RegisterUsagesPanel;
import org.netbeans.modules.asm.model.AsmModelAccessor;
import org.netbeans.modules.asm.model.lang.OperandElement;
import org.netbeans.modules.asm.model.util.IntervalSet;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

public class RegisterHighlightAssistance
extends AbstractHighlightsContainer
implements CaretListener,
AsmModelAccessor.ParseListener {
    public static final String LAYER_NAME = "reg-highlight-layer";
    public static final Color READ_COLORING = RegisterUsagesPanel.READ_COLOR;
    public static final Color WRITE_COLORING = RegisterUsagesPanel.WRITE_COLOR;
    private final JTextComponent pane;
    private IntervalSet<RegisterHighlightAction.HighlightEntry> highlight = new IntervalSet();
    private final RegisterHighlightAction action = new RegisterHighlightAction();

    public RegisterHighlightAssistance(JTextComponent jTextComponent, Document document) {
        this.pane = jTextComponent;
        jTextComponent.addCaretListener(this);
        AsmModelAccessor asmModelAccessor = AsmObjectUtilities.getAccessor(document);
        if (asmModelAccessor == null) {
            return;
        }
        asmModelAccessor.addParseListener(this);
    }

    private void update() {
        AsmModelAccessor asmModelAccessor = AsmObjectUtilities.getAccessor(this.pane);
        if (asmModelAccessor == null) {
            return;
        }
        IntervalSet<RegisterHighlightAction.HighlightEntry> intervalSet = this.action.getHighlight(asmModelAccessor.getState(), this.pane.getCaretPosition());
        if (intervalSet.isEmpty() && this.highlight.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (intervalSet.isEmpty()) {
            n = this.highlight.getLowerBound();
            n2 = this.highlight.getUpperBound();
        } else if (this.highlight.isEmpty()) {
            n = intervalSet.getLowerBound();
            n2 = intervalSet.getUpperBound();
        } else {
            n = Math.min(this.highlight.getLowerBound(), intervalSet.getLowerBound());
            n2 = Math.max(this.highlight.getUpperBound(), intervalSet.getUpperBound());
        }
        this.highlight = intervalSet;
        super.fireHighlightsChange(n, n2);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.update();
    }

    public void notifyParsed() {
        this.update();
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return new RegisterHighlightsSequence(this.highlight.getFromBounds(n, n2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegisterHighlightsSequence
    implements HighlightsSequence {
        private RegisterHighlightAction.HighlightEntry cur;
        private Iterator<RegisterHighlightAction.HighlightEntry> it;

        public RegisterHighlightsSequence(IntervalSet<RegisterHighlightAction.HighlightEntry> intervalSet) {
            this.it = intervalSet.iterator();
        }

        public boolean moveNext() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.cur = this.it.next();
            return true;
        }

        public int getStartOffset() {
            return this.cur.getStartOffset();
        }

        public int getEndOffset() {
            return this.cur.getEndOffset();
        }

        public AttributeSet getAttributes() {
            Color color = null;
            if (this.cur.getUsage().contains(OperandElement.Usage.OP_USE_WRITE)) {
                color = WRITE_COLORING;
            } else if (this.cur.getUsage().contains(OperandElement.Usage.OP_USE_READ)) {
                color = READ_COLORING;
            }
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (color != null) {
                simpleAttributeSet.addAttribute(StyleConstants.Background, color);
            }
            return simpleAttributeSet;
        }
    }
}

