/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.core.hyperlink;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.asm.core.assistance.GoToLabelAction;
import org.netbeans.modules.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.asm.model.AsmState;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public class AsmHyperlinkProvider
implements HyperlinkProvider {
    private Document lastDocument;
    private int[] lastResult;
    private final GoToLabelAction labelResolver = new GoToLabelAction();

    public AsmHyperlinkProvider() {
        this.lastResult = new int[]{-1, -1, -1};
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        int[] nArray;
        AsmState asmState = AsmObjectUtilities.getAccessor(document).getState();
        this.lastDocument = document;
        if (asmState != null && (nArray = this.labelResolver.computeLabel(asmState, n))[0] != -1) {
            this.lastResult = nArray;
            return true;
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (document != this.lastDocument && !this.checkResult()) {
            return null;
        }
        return new int[]{this.lastResult[0], this.lastResult[1]};
    }

    public void performClickAction(Document document, int n) {
        if (document != this.lastDocument || !this.checkResult()) {
            return;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        int n2 = this.lastResult[2];
        if (!this.openFileInEditor(dataObject)) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                editorCookie.openDocument();
            }
            catch (IOException iOException) {
                return;
            }
            JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
            jEditorPane.setCaretPosition(n2);
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPane);
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    private boolean checkResult() {
        return this.lastResult[0] != -1 && this.lastResult[1] != -1 && this.lastResult[2] != -1;
    }

    private boolean openFileInEditor(DataObject dataObject) {
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }
}

