/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.model.xml;

import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.asm.model.xml.ModelXMLReaderException;
import org.netbeans.modules.asm.model.xml.XMLReaderContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModelXMLReader {
    private static final String START_ELEMENT_SUFFIX = "Start";
    private static final String END_ELEMENT_SUFFIX = "End";

    public void readModelXml(Reader reader, XMLReaderContext xMLReaderContext) {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(new ModelXMLContentHandler(xMLReaderContext));
            xMLReader.parse(new InputSource(reader));
        }
        catch (ModelXMLReaderException modelXMLReaderException) {
            throw modelXMLReaderException;
        }
        catch (Exception exception) {
            throw new ModelXMLReaderException(exception);
        }
    }

    private static class ModelXMLContentHandler
    extends DefaultHandler {
        private List<XMLReaderContext> ctxStack;
        private XMLReaderContext ctxCur;

        public ModelXMLContentHandler(XMLReaderContext xMLReaderContext) {
            this.ctxCur = xMLReaderContext;
            this.ctxStack = new LinkedList<XMLReaderContext>();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.ctxStack.add(this.ctxCur);
            Object object = this.invokeCtxMethod(string3 + ModelXMLReader.START_ELEMENT_SUFFIX, attributes, Attributes.class);
            if (object instanceof XMLReaderContext) {
                this.ctxCur = (XMLReaderContext)object;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            XMLReaderContext xMLReaderContext = this.ctxCur;
            this.ctxCur = this.ctxStack.remove(this.ctxStack.size() - 1);
            this.invokeCtxMethod(string3 + ModelXMLReader.END_ELEMENT_SUFFIX, xMLReaderContext, xMLReaderContext.getClass());
        }

        private Object invokeCtxMethod(String string, Object object, Class clazz) {
            Object object2 = null;
            Method method = null;
            if (this.ctxCur == null || object == null) {
                return object2;
            }
            try {
                method = this.ctxCur.getClass().getMethod(string, clazz);
            }
            catch (Exception exception) {
                return null;
            }
            try {
                object2 = method.invoke((Object)this.ctxCur, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ModelXMLReaderException(invocationTargetException.getTargetException().toString());
            }
            catch (Exception exception) {
                throw new ModelXMLReaderException(exception);
            }
            return object2;
        }
    }
}

