/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;

final class OnTimerRefreshVisualizerHandler
implements SessionStateListener,
DLightSessionListener {
    private final OnTimerTask task;
    private final long period;
    private final TimeUnit unit;
    private Future scheduledTask;
    private DLightSession.SessionState currentSessionState = null;

    protected OnTimerRefreshVisualizerHandler(OnTimerTask onTimerTask, long l, TimeUnit timeUnit) {
        this.task = onTimerTask;
        this.period = l;
        this.unit = timeUnit;
        DLightManager dLightManager = DLightManager.getDefault();
        DLightSession dLightSession = dLightManager.getActiveSession();
        dLightManager.addDLightSessionListener((DLightSessionListener)this);
        dLightSession.addSessionStateListener((SessionStateListener)this);
        this.currentSessionState = dLightSession.getState();
    }

    protected boolean isSessionRunning() {
        return this.currentSessionState == DLightSession.SessionState.RUNNING;
    }

    protected boolean isSessionPaused() {
        return this.currentSessionState == DLightSession.SessionState.PAUSED;
    }

    protected boolean isSessionAnalyzed() {
        return this.currentSessionState == DLightSession.SessionState.ANALYZE;
    }

    synchronized void startTimer() {
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

            public void run() {
                OnTimerRefreshVisualizerHandler.this.task.onTimer();
            }
        }, (long)this.period, (TimeUnit)this.unit, (String)"OnTimerRefreshVisualizerHandler");
    }

    synchronized void stopTimer() {
        if (this.scheduledTask == null || this.scheduledTask.isDone()) {
            return;
        }
        this.scheduledTask.cancel(true);
        this.task.timerStopped();
    }

    public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        this.currentSessionState = sessionState2;
        if (sessionState2 == DLightSession.SessionState.PAUSED || sessionState2 == DLightSession.SessionState.ANALYZE) {
            this.stopTimer();
            return;
        }
        if (sessionState2 == DLightSession.SessionState.STARTING || sessionState2 == DLightSession.SessionState.RUNNING) {
            this.startTimer();
            return;
        }
    }

    public void activeSessionChanged(DLightSession dLightSession, DLightSession dLightSession2) {
        if (dLightSession != null) {
            dLightSession.removeSessionStateListener((SessionStateListener)this);
            this.stopTimer();
        }
        if (dLightSession2 != null) {
            dLightSession2.addSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(dLightSession2, DLightSession.SessionState.CONFIGURATION, dLightSession2.getState());
        }
    }

    public void sessionAdded(DLightSession dLightSession) {
    }

    public void sessionRemoved(DLightSession dLightSession) {
        if (dLightSession != null) {
            dLightSession.removeSessionStateListener((SessionStateListener)this);
            this.stopTimer();
        }
    }
}

