/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client.filter;

import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.container.ContainerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingFilter
extends ClientFilter {
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = "> ";
    private static final String RESPONSE_PREFIX = "< ";
    private final PrintStream loggingStream;
    private long _id = 0L;

    public LoggingFilter() {
        this(System.out);
    }

    public LoggingFilter(PrintStream loggingStream) {
        this.loggingStream = loggingStream;
    }

    private PrintStream prefixId(long id) {
        this.loggingStream.append(Long.toString(id)).append(" ");
        return this.loggingStream;
    }

    @Override
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        long id = ++this._id;
        this.printRequestLine(id, request);
        this.printRequestHeaders(id, request.getMetadata());
        request.setAdapter(new Adapter(request.getAdapter()));
        ClientResponse response = this.getNext().handle(request);
        this.printResponseLine(id, response);
        this.printResponseHeaders(id, response.getMetadata());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = response.getEntityInputStream();
        try {
            int read;
            byte[] data = new byte[2048];
            while ((read = in.read(data)) != -1) {
                out.write(data, 0, read);
            }
            byte[] requestEntity = out.toByteArray();
            this.printResponseEntity(requestEntity);
            response.setEntityInputStream(new ByteArrayInputStream(requestEntity));
        }
        catch (IOException ex) {
            throw new ContainerException(ex);
        }
        this.prefixId(id).append(NOTIFICATION_PREFIX).append("In-bound response").println();
        return response;
    }

    private void printRequestLine(long id, ClientRequest request) {
        this.prefixId(id).append(NOTIFICATION_PREFIX).append("Out-bound request").println();
        this.prefixId(id).append(REQUEST_PREFIX).append(request.getMethod()).append(" ").append(request.getURI().toASCIIString()).println();
    }

    private void printRequestHeaders(long id, MultivaluedMap<String, Object> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (Object value : (List)e.getValue()) {
                this.prefixId(id).append(REQUEST_PREFIX).append(header).append(": ").append(ClientRequest.getHeaderValue(value)).println();
            }
        }
        this.prefixId(id).println(REQUEST_PREFIX);
    }

    private void printResponseLine(long id, ClientResponse response) {
        this.prefixId(id).append(RESPONSE_PREFIX).append(Integer.toString(response.getStatus())).println();
    }

    private void printResponseHeaders(long id, MultivaluedMap<String, String> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                this.prefixId(id).append(RESPONSE_PREFIX).append(header).append(": ").append(value).println();
            }
        }
        this.prefixId(id).println(RESPONSE_PREFIX);
    }

    private void printResponseEntity(byte[] responseEntity) throws IOException {
        if (responseEntity.length == 0) {
            return;
        }
        this.loggingStream.write(responseEntity);
        this.loggingStream.println();
    }

    private final class LoggingOutputStream
    extends OutputStream {
        private boolean init = false;
        private OutputStream out;

        LoggingOutputStream(OutputStream out) {
            this.out = out;
        }

        public void write(byte[] b) throws IOException {
            this.init();
            LoggingFilter.this.loggingStream.write(b);
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            LoggingFilter.this.loggingStream.write(b, off, len);
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.init();
            LoggingFilter.this.loggingStream.write(b);
            this.out.write(b);
        }

        public void close() throws IOException {
            this.finish();
            this.out.close();
        }

        private final void init() {
            if (!this.init) {
                this.init = true;
            }
        }

        private final void finish() {
            if (this.init) {
                LoggingFilter.this.loggingStream.println();
                this.init = false;
            }
        }
    }

    private final class Adapter
    extends AbstractClientRequestAdapter {
        Adapter(ClientRequestAdapter cra) {
            super(cra);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new LoggingOutputStream(this.getAdapter().adapt(request, out));
        }
    }
}

