/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.json;

import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.impl.json.JSONTransformer;
import com.sun.jersey.impl.json.reader.JsonXmlStreamReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamReader;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUnmarshaller
implements Unmarshaller {
    private Unmarshaller jaxbUnmarshaller;
    private JSONJAXBContext.JSONNotation jsonNotation;
    private boolean jsonEnabled;
    private boolean jsonRootUnwrapping;
    private Collection<String> attrAsElemNames;
    private Map<String, String> xml2jsonNamespace;

    public JSONUnmarshaller(JAXBContext jaxbContext, Map<String, Object> properties) throws JAXBException {
        try {
            this.jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            this.setProperties(properties);
        }
        catch (PropertyException ex) {
            Logger.getLogger(JSONUnmarshaller.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Object unmarshal(InputStream inputStream, Class<Object> type) throws JAXBException {
        if (this.jsonEnabled) {
            if (null != type) {
                return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(new InputStreamReader(inputStream)), type);
            }
            return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(new InputStreamReader(inputStream)));
        }
        return this.jaxbUnmarshaller.unmarshal(inputStream);
    }

    public Object unmarshal(Reader reader, Class<Object> type) throws JAXBException {
        if (this.jsonEnabled) {
            if (null != type) {
                return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader), type);
            }
            return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(reader));
        }
        return this.jaxbUnmarshaller.unmarshal(reader);
    }

    public Object unmarshal(File file) throws JAXBException {
        if (this.jsonEnabled) {
            try {
                return this.jaxbUnmarshaller.unmarshal(this.createXmlStreamReader(new FileReader(file)));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(JSONUnmarshaller.class.getName()).log(Level.SEVERE, null, ex);
                throw new JAXBException((Throwable)ex);
            }
        }
        return this.jaxbUnmarshaller.unmarshal(file);
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        return this.unmarshal(inputStream, null);
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        return this.unmarshal(reader, null);
    }

    public Object unmarshal(URL url) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(url);
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(inputSource);
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(node);
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(node, type);
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(source);
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(source, type);
    }

    public Object unmarshal(XMLStreamReader xmlStreamReader) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlStreamReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader xmlStreamReader, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlStreamReader, type);
    }

    public Object unmarshal(XMLEventReader xmlEventReader) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlEventReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader xmlEventReader, Class<T> type) throws JAXBException {
        if (this.jsonEnabled) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return this.jaxbUnmarshaller.unmarshal(xmlEventReader, type);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.jaxbUnmarshaller.getUnmarshallerHandler();
    }

    public void setValidating(boolean validating) throws JAXBException {
        this.jaxbUnmarshaller.setValidating(validating);
    }

    public boolean isValidating() throws JAXBException {
        return this.jaxbUnmarshaller.isValidating();
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.jaxbUnmarshaller.setEventHandler(validationEventHandler);
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.jaxbUnmarshaller.getEventHandler();
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if ("com.sun.jersey.impl.json.enabled".equals(key)) {
            this.jsonEnabled = (Boolean)value;
        } else if ("com.sun.jersey.impl.json.notation".equals(key)) {
            this.jsonNotation = value instanceof JSONJAXBContext.JSONNotation ? (JSONJAXBContext.JSONNotation)((Object)value) : JSONJAXBContext.JSONNotation.valueOf((String)value);
        } else if ("com.sun.jersey.impl.json.root.unwrapping".equals(key)) {
            this.jsonRootUnwrapping = (Boolean)value;
        } else if ("com.sun.jersey.impl.json.xml.to.json.ns".equals(key)) {
            if (Map.class.isAssignableFrom(value.getClass())) {
                this.xml2jsonNamespace = (Map)value;
            } else {
                try {
                    this.xml2jsonNamespace = JSONTransformer.asMap((String)value);
                }
                catch (JSONException e) {
                    throw new PropertyException("JSON exception when trying to set com.sun.jersey.impl.json.xml.to.json.ns property.", (Throwable)e);
                }
            }
        } else if ("com.sun.jersey.impl.json.attrs.as.elems".equals(key)) {
            if (Collection.class.isAssignableFrom(value.getClass())) {
                this.attrAsElemNames = (Collection)value;
            } else {
                try {
                    this.attrAsElemNames = JSONTransformer.asCollection((String)value);
                }
                catch (JSONException e) {
                    throw new PropertyException("JSON exception when trying to set com.sun.jersey.impl.json.attrs.as.elems property.", (Throwable)e);
                }
            }
        } else if (!key.startsWith("com.sun.jersey.impl.json.")) {
            this.jaxbUnmarshaller.setProperty(key, value);
        }
    }

    public Object getProperty(String key) throws PropertyException {
        if ("com.sun.jersey.impl.json.enabled".equals(key)) {
            return this.jsonEnabled;
        }
        if ("com.sun.jersey.impl.json.notation".equals(key)) {
            return this.jsonNotation;
        }
        if ("com.sun.jersey.impl.json.root.unwrapping".equals(key)) {
            return this.jsonRootUnwrapping;
        }
        if ("com.sun.jersey.impl.json.xml.to.json.ns".equals(key)) {
            return this.xml2jsonNamespace;
        }
        if ("com.sun.jersey.impl.json.attrs.as.elems".equals(key)) {
            return this.attrAsElemNames;
        }
        if (key.startsWith("com.sun.jersey.impl.json.")) {
            return null;
        }
        return this.jaxbUnmarshaller.getProperty(key);
    }

    public void setSchema(Schema schema) {
        this.jaxbUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.jaxbUnmarshaller.getSchema();
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        this.jaxbUnmarshaller.setAdapter(xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.jaxbUnmarshaller.setAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.jaxbUnmarshaller.getAdapter(type);
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        this.jaxbUnmarshaller.setAttachmentUnmarshaller(attachmentUnmarshaller);
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.jaxbUnmarshaller.getAttachmentUnmarshaller();
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.jaxbUnmarshaller.setListener(listener);
    }

    public Unmarshaller.Listener getListener() {
        return this.jaxbUnmarshaller.getListener();
    }

    private void setProperties(Map<String, Object> properties) throws PropertyException {
        if (null != properties) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private XMLStreamReader createXmlStreamReader(Reader reader) {
        if (JSONJAXBContext.JSONNotation.MAPPED == this.jsonNotation) {
            try {
                return new JsonXmlStreamReader(reader, this.jsonRootUnwrapping ? "rootElement" : null, this.attrAsElemNames);
            }
            catch (IOException ex) {
                Logger.getLogger(JSONUnmarshaller.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (JSONJAXBContext.JSONNotation.MAPPED_JETTISON == this.jsonNotation) {
            try {
                Configuration jmConfig = null == this.xml2jsonNamespace ? new Configuration() : new Configuration(this.xml2jsonNamespace);
                return new MappedXMLStreamReader(new JSONObject(new JSONTokener(this.readFromAsString(reader))), new MappedNamespaceConvention(jmConfig));
            }
            catch (Exception ex) {
                Logger.getLogger(JSONUnmarshaller.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                return new BadgerFishXMLStreamReader(new JSONObject(new JSONTokener(this.readFromAsString(reader))));
            }
            catch (Exception ex) {
                Logger.getLogger(JSONUnmarshaller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private String readFromAsString(Reader reader) throws IOException {
        int l;
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1024];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }
}

