/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.provider.entity.AbstractJAXBProvider;
import com.sun.jersey.impl.provider.entity.Inflector;
import com.sun.jersey.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListElementProvider
extends AbstractJAXBProvider<Collection<?>> {
    private final Inflector inflector = Inflector.getInstance();

    public AbstractListElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractListElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type != List.class && type != Collection.class) {
            return false;
        }
        return this.verify(genericType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!List.class.isAssignableFrom(type)) {
            return false;
        }
        return this.verify(genericType);
    }

    private boolean verify(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        if (pt.getActualTypeArguments().length > 1) {
            return false;
        }
        if (!(pt.getActualTypeArguments()[0] instanceof Class)) {
            return false;
        }
        Class listClass = (Class)pt.getActualTypeArguments()[0];
        return listClass.isAnnotationPresent(XmlRootElement.class) || listClass.isAnnotationPresent(XmlType.class);
    }

    public final void writeTo(Collection<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Class elementType = this.getElementClass(type, genericType);
            Charset c = AbstractListElementProvider.getCharset(mediaType);
            String cName = c.name();
            Marshaller m = this.getMarshaller(elementType, mediaType);
            m.setProperty("jaxb.fragment", (Object)true);
            if (c != UTF8) {
                m.setProperty("jaxb.encoding", (Object)cName);
            }
            this.writeList(elementType, t, mediaType, c, m, entityStream);
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }

    public abstract void writeList(Class<?> var1, Collection<?> var2, MediaType var3, Charset var4, Marshaller var5, OutputStream var6) throws JAXBException, IOException;

    public final List<?> readFrom(Class<Collection<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            Class elementType = this.getElementClass(type, genericType);
            Unmarshaller u = this.getUnmarshaller(elementType, mediaType);
            XMLStreamReader r = this.getXMLStreamReader(mediaType, entityStream);
            ArrayList<Object> l = new ArrayList<Object>();
            r.nextTag();
            int event = r.next();
            while (event != 1 && event != 8) {
                event = r.next();
            }
            while (event != 8) {
                if (elementType.isAnnotationPresent(XmlRootElement.class)) {
                    l.add(u.unmarshal(r));
                } else {
                    l.add(u.unmarshal(r, elementType).getValue());
                }
                event = r.getEventType();
                while (event != 1 && event != 8) {
                    event = r.next();
                }
            }
            return l;
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_UNMARSHALLING_JAXB(type)));
        }
        catch (XMLStreamException cause) {
            throw ThrowHelper.withInitCause(cause, new IOException(ImplMessages.ERROR_UNMARSHALLING_JAXB(type)));
        }
    }

    protected abstract XMLStreamReader getXMLStreamReader(MediaType var1, InputStream var2) throws XMLStreamException;

    protected Class getElementClass(Class<?> type, Type genericType) {
        ParameterizedType pt = (ParameterizedType)genericType;
        return (Class)pt.getActualTypeArguments()[0];
    }

    private final String convertToXmlName(String name) {
        return name.replace("$", "_");
    }

    protected final String getRootElementName(Class<?> elementType) {
        return this.convertToXmlName(this.inflector.pluralize(this.inflector.demodulize(elementType.getName())));
    }
}

