/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl.generators;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.jersey.impl.wadl.generators.ApplicationDocs;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.RepresentationType;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.File;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlGeneratorApplicationDoc
implements WadlGenerator {
    private static final Logger LOG = Logger.getLogger(WadlGeneratorApplicationDoc.class.getName());
    private WadlGenerator _delegate;
    private File _applicationDocsFile;
    private ApplicationDocs _applicationDocs;

    public WadlGeneratorApplicationDoc() {
    }

    public WadlGeneratorApplicationDoc(WadlGenerator wadlGenerator, ApplicationDocs applicationDocs) {
        this._delegate = wadlGenerator;
        this._applicationDocs = applicationDocs;
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    public void setApplicationDocsFile(File applicationDocsFile) {
        this._applicationDocsFile = applicationDocsFile;
        LOG.info("Setting grammarsFile " + applicationDocsFile.getAbsolutePath());
    }

    @Override
    public void init() throws Exception {
        this._delegate.init();
        this._applicationDocs = this.loadFile(this._applicationDocsFile, ApplicationDocs.class);
    }

    private <T> T loadFile(File fileToLoad, Class<T> targetClass) throws JAXBException {
        String name = targetClass.getName();
        int i = name.lastIndexOf(46);
        name = i != -1 ? name.substring(0, i) : "";
        JAXBContext c = JAXBContext.newInstance((String)name, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Unmarshaller m = c.createUnmarshaller();
        return targetClass.cast(m.unmarshal(fileToLoad));
    }

    @Override
    public Application createApplication() {
        Application result = this._delegate.createApplication();
        if (this._applicationDocs != null && this._applicationDocs.getDocs() != null && !this._applicationDocs.getDocs().isEmpty()) {
            result.getDoc().addAll(this._applicationDocs.getDocs());
        }
        return result;
    }

    @Override
    public Method createMethod(AbstractResource r, AbstractResourceMethod m) {
        return this._delegate.createMethod(r, m);
    }

    @Override
    public RepresentationType createRequestRepresentation(AbstractResource r, AbstractResourceMethod m, MediaType mediaType) {
        return this._delegate.createRequestRepresentation(r, m, mediaType);
    }

    @Override
    public Request createRequest(AbstractResource r, AbstractResourceMethod m) {
        return this._delegate.createRequest(r, m);
    }

    @Override
    public Param createParam(AbstractResource r, AbstractMethod m, Parameter p) {
        return this._delegate.createParam(r, m, p);
    }

    @Override
    public Resource createResource(AbstractResource r, String path) {
        return this._delegate.createResource(r, path);
    }

    @Override
    public Response createResponse(AbstractResource r, AbstractResourceMethod m) {
        return this._delegate.createResponse(r, m);
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }
}

