/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.wadl.generators;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.impl.wadl.WadlGenerator;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Grammars;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.RepresentationType;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import java.io.File;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlGeneratorGrammarsSupport
implements WadlGenerator {
    private static final Logger LOG = Logger.getLogger(WadlGeneratorGrammarsSupport.class.getName());
    private WadlGenerator _delegate;
    private File _grammarsFile;
    private Grammars _grammars;

    public WadlGeneratorGrammarsSupport() {
    }

    public WadlGeneratorGrammarsSupport(WadlGenerator delegate, Grammars grammars) {
        this._delegate = delegate;
        this._grammars = grammars;
    }

    @Override
    public void setWadlGeneratorDelegate(WadlGenerator delegate) {
        this._delegate = delegate;
    }

    @Override
    public String getRequiredJaxbContextPath() {
        return this._delegate.getRequiredJaxbContextPath();
    }

    public void setGrammarsFile(File grammarsFile) {
        this._grammarsFile = grammarsFile;
        LOG.info("Setting grammarsFile " + grammarsFile.getAbsolutePath());
    }

    @Override
    public void init() throws Exception {
        this._delegate.init();
        this._grammars = this.loadFile(this._grammarsFile, Grammars.class);
    }

    private <T> T loadFile(File fileToLoad, Class<T> targetClass) throws JAXBException {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{targetClass});
        Unmarshaller m = c.createUnmarshaller();
        return targetClass.cast(m.unmarshal(fileToLoad));
    }

    @Override
    public Application createApplication() {
        Application result = this._delegate.createApplication();
        if (result.getGrammars() != null) {
            LOG.info("The wadl application created by the delegate (" + this._delegate + ") already contains a grammars element," + " we're adding elements of the provided grammars file.");
            if (!this._grammars.getAny().isEmpty()) {
                result.getGrammars().getAny().addAll(this._grammars.getAny());
            }
            if (!this._grammars.getDoc().isEmpty()) {
                result.getGrammars().getDoc().addAll(this._grammars.getDoc());
            }
            if (!this._grammars.getInclude().isEmpty()) {
                result.getGrammars().getInclude().addAll(this._grammars.getInclude());
            }
        } else {
            result.setGrammars(this._grammars);
        }
        return result;
    }

    @Override
    public Method createMethod(AbstractResource arg0, AbstractResourceMethod arg1) {
        return this._delegate.createMethod(arg0, arg1);
    }

    @Override
    public Request createRequest(AbstractResource arg0, AbstractResourceMethod arg1) {
        return this._delegate.createRequest(arg0, arg1);
    }

    @Override
    public Param createParam(AbstractResource arg0, AbstractMethod arg1, Parameter arg2) {
        return this._delegate.createParam(arg0, arg1, arg2);
    }

    @Override
    public RepresentationType createRequestRepresentation(AbstractResource arg0, AbstractResourceMethod arg1, MediaType arg2) {
        return this._delegate.createRequestRepresentation(arg0, arg1, arg2);
    }

    @Override
    public Resource createResource(AbstractResource arg0, String arg1) {
        return this._delegate.createResource(arg0, arg1);
    }

    @Override
    public Resources createResources() {
        return this._delegate.createResources();
    }

    @Override
    public Response createResponse(AbstractResource arg0, AbstractResourceMethod arg1) {
        return this._delegate.createResponse(arg0, arg1);
    }
}

