/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.service;

import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.service.ComponentContext;
import com.sun.jersey.spi.service.ComponentProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConstructor {
    protected final InjectableProviderContext ipc;

    public ComponentConstructor(InjectableProviderContext ipc) {
        this.ipc = ipc;
    }

    public <T> ConstructorInjectablePair<T> getConstructor(Class<T> c) {
        if (c.getConstructors().length == 0) {
            return null;
        }
        TreeSet cs = new TreeSet(new ConstructorComparator());
        InjectableProviderFactory.AnnotationObjectContext aoc = new InjectableProviderFactory.AnnotationObjectContext();
        for (Constructor<?> con : c.getConstructors()) {
            ArrayList<Injectable> is = new ArrayList<Injectable>();
            int ps = con.getParameterTypes().length;
            for (int p = 0; p < ps; ++p) {
                Type pgtype = con.getGenericParameterTypes()[p];
                Annotation[] as = con.getParameterAnnotations()[p];
                aoc.setAnnotations(as);
                Injectable i = null;
                for (Annotation a : as) {
                    i = this.ipc.getInjectable(a.annotationType(), (ComponentContext)aoc, a, pgtype, ComponentProvider.Scope.UNDEFINED_SINGLETON);
                }
                is.add(i);
            }
            cs.add(new ConstructorInjectablePair(con, is));
        }
        return (ConstructorInjectablePair)cs.first();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorComparator<T>
    implements Comparator<ConstructorInjectablePair<T>> {
        @Override
        public int compare(ConstructorInjectablePair<T> o1, ConstructorInjectablePair<T> o2) {
            int p = Collections.frequency(o1.is, null) - Collections.frequency(o2.is, null);
            if (p != 0) {
                return p;
            }
            return o2.con.getParameterTypes().length - o1.con.getParameterTypes().length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorInjectablePair<T> {
        public final Constructor<T> con;
        public final List<Injectable> is;

        public ConstructorInjectablePair(Constructor<T> con, List<Injectable> is) {
            this.con = con;
            this.is = is;
        }
    }
}

