/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.CategoryListener;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Model;
import org.netbeans.modules.palette.ModelListener;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class DefaultSettings
implements Settings,
ModelListener,
CategoryListener {
    private static final String NODE_ATTR_PREFIX = "psa_";
    private static final String NULL_VALUE = "null";
    private static final String XML_ROOT = "root";
    private static final String XML_CATEGORY = "category";
    private static final String XML_ITEM = "item";
    private static final String XML_ATTR_NAME = "name";
    private static final String[] KNOWN_PROPERTIES = new String[]{"psa_iconSize", "psa_isExpanded", "psa_isVisible", "psa_showItemNames"};
    private static final int ICON_SIZE_ATTR_INDEX = 0;
    private static final int IS_EXPANDED_ATTR_INDEX = 1;
    private static final int IS_VISIBLE_ATTR_INDEX = 2;
    private static final int SHOW_ITEM_NAMES_ATTR_INDEX = 3;
    private Model model;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String prefsName;
    private static Logger ERR = Logger.getLogger("org.netbeans.modules.palette");
    private boolean isLoading = false;

    public DefaultSettings(Model model) {
        this.model = model;
        this.prefsName = this.constructPrefsFileName(model);
        if (Utilities.isWindows()) {
            this.prefsName = this.prefsName.toLowerCase();
        }
        model.addModelListener(this);
        Category[] categoryArray = model.getCategories();
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i].addCategoryListener(this);
        }
        this.load();
    }

    private String constructPrefsFileName(Model model) {
        FileObject fileObject;
        DataFolder dataFolder = (DataFolder)model.getRoot().lookup(DataFolder.class);
        if (null != dataFolder && null != (fileObject = dataFolder.getPrimaryFile())) {
            return fileObject.getPath();
        }
        return model.getName();
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(DefaultSettings.class).node("CommonPaletteSettings").node(this.prefsName);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isVisible(Item item) {
        Node node = this.getNode(item.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Item item, boolean bl) {
        Node node = this.getNode(item.getLookup());
        this.set(node, "isVisible", bl, true);
    }

    public boolean isVisible(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isVisible", true);
    }

    public void setVisible(Category category, boolean bl) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isVisible", bl, true);
    }

    public boolean isNodeVisible(Node node) {
        return this.get(node, "isVisible", true);
    }

    public void setNodeVisible(Node node, boolean bl) {
        this.set(node, "isVisible", bl, true);
    }

    public boolean isExpanded(Category category) {
        Node node = this.getNode(category.getLookup());
        return this.get(node, "isExpanded", false);
    }

    public void setExpanded(Category category, boolean bl) {
        Node node = this.getNode(category.getLookup());
        this.set(node, "isExpanded", bl, false);
    }

    public int getIconSize() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "iconSize", 1);
    }

    public void setIconSize(int n) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "iconSize", n, 1);
    }

    public void setShowItemNames(boolean bl) {
        Node node = this.getNode(this.model.getRoot());
        this.set(node, "showItemNames", bl, true);
    }

    public boolean getShowItemNames() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "showItemNames", true);
    }

    private Node getNode(Lookup lookup) {
        return (Node)lookup.lookup(Node.class);
    }

    private boolean get(Node node, String string, boolean bl) {
        Object object = this.get(node, string, (Object)bl);
        return null == object ? bl : Boolean.valueOf(object.toString());
    }

    private int get(Node node, String string, int n) {
        Object object = this.get(node, string, (Object)n);
        try {
            if (null != object) {
                return Integer.parseInt(object.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private Object get(Node node, String string, Object object) {
        Object object2 = null;
        if (null != node && (null == (object2 = node.getValue(NODE_ATTR_PREFIX + string)) || NULL_VALUE.equals(object2))) {
            object2 = this.getNodeDefaultValue(node, string);
        }
        if (null == object2) {
            object2 = object;
        }
        return object2;
    }

    private Object getNodeDefaultValue(Node node, String string) {
        DataObject dataObject;
        Object object = node.getValue(string);
        if (null == object && null != (dataObject = (DataObject)node.getCookie(DataObject.class))) {
            object = dataObject.getPrimaryFile().getAttribute(string);
        }
        return object;
    }

    private void set(Node node, String string, boolean bl, boolean bl2) {
        this.set(node, string, (Object)bl, (Object)bl2);
    }

    private void set(Node node, String string, int n, int n2) {
        this.set(node, string, (Object)n, (Object)n2);
    }

    private void set(Node node, String string, Object object, Object object2) {
        if (null == node) {
            return;
        }
        Object object3 = this.get(node, string, object2);
        if (object3.equals(object)) {
            return;
        }
        node.setValue(NODE_ATTR_PREFIX + string, object);
        this.store();
        this.propertySupport.firePropertyChange(string, object3, object);
    }

    public void categoryModified(Category category) {
        this.store();
    }

    public void categoriesRemoved(Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i].removeCategoryListener(this);
        }
        this.store();
    }

    public void categoriesAdded(Category[] categoryArray) {
        for (int i = 0; i < categoryArray.length; ++i) {
            categoryArray[i].addCategoryListener(this);
        }
        this.store();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void categoriesReordered() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        try {
            this.isLoading = true;
            Preferences preferences = this.getPreferences();
            this.setIconSize(preferences.getInt("iconSize", this.getIconSize()));
            this.setShowItemNames(preferences.getBoolean("showItemNames", this.getShowItemNames()));
            for (Category category : this.model.getCategories()) {
                this.setVisible(category, preferences.getBoolean(category.getName() + '-' + "isVisible", this.isVisible(category)));
                this.setExpanded(category, preferences.getBoolean(category.getName() + '-' + "isExpanded", this.isExpanded(category)));
                for (Item item : category.getItems()) {
                    this.setVisible(item, preferences.getBoolean(category.getName() + '-' + item.getName() + '-' + "isVisible", this.isVisible(item)));
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    private void store() {
        if (this.isLoading) {
            return;
        }
        Preferences preferences = this.getPreferences();
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_StoreSettings"), backingStoreException);
        }
        preferences.putInt("iconSize", this.getIconSize());
        preferences.putBoolean("showItemNames", this.getShowItemNames());
        for (Category category : this.model.getCategories()) {
            preferences.putBoolean(category.getName() + '-' + "isVisible", this.isVisible(category));
            preferences.putBoolean(category.getName() + '-' + "isExpanded", this.isExpanded(category));
            for (Item item : category.getItems()) {
                preferences.putBoolean(category.getName() + '-' + item.getName() + '-' + "isVisible", this.isVisible(item));
            }
        }
    }

    public int getItemWidth() {
        Node node = this.getNode(this.model.getRoot());
        return this.get(node, "itemWidth", -1);
    }

    public void reset() {
        Node node = (Node)this.model.getRoot().lookup(Node.class);
        this.clearAttributes(node);
        Category[] categoryArray = this.model.getCategories();
        for (int i = 0; i < categoryArray.length; ++i) {
            Node node2 = (Node)categoryArray[i].getLookup().lookup(Node.class);
            this.clearAttributes(node2);
            Item[] itemArray = categoryArray[i].getItems();
            for (int j = 0; j < itemArray.length; ++j) {
                Node node3 = (Node)itemArray[j].getLookup().lookup(Node.class);
                this.clearAttributes(node3);
            }
        }
        try {
            this.getPreferences().removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            ERR.log(Level.INFO, Utils.getBundleString("Err_StoreSettings"), backingStoreException);
        }
    }

    private void clearAttributes(Node node) {
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            node.setValue(KNOWN_PROPERTIES[i], (Object)NULL_VALUE);
        }
    }
}

