/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.modules.palette.Category;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.AutoscrollSupport;
import org.netbeans.modules.palette.ui.CategoryDescriptor;
import org.netbeans.modules.palette.ui.CategoryList;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

class CategoryButton
extends JCheckBox
implements Autoscroll {
    static final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    static final boolean isNimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
    static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private CategoryDescriptor descriptor;
    private Category category;
    private AutoscrollSupport support;

    public String getUIClassID() {
        String string = super.getUIClassID();
        if (isGTK) {
            string = "MetalCheckBoxUI_4_GTK";
        }
        return string;
    }

    CategoryButton(CategoryDescriptor categoryDescriptor, Category category) {
        this.descriptor = categoryDescriptor;
        this.category = category;
        UIManager.get("nb.propertysheet");
        this.setFont(this.getFont().deriveFont(1));
        this.setMargin(new Insets(0, 3, 0, 3));
        this.setFocusPainted(false);
        this.setSelected(false);
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(4);
        this.setVerticalTextPosition(0);
        this.updateProperties();
        if (this.getBorder() instanceof CompoundBorder) {
            Dimension dimension = this.getPreferredSize();
            dimension.height -= 3;
            this.setPreferredSize(dimension);
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !CategoryButton.this.descriptor.isOpened();
                CategoryButton.this.setExpanded(bl);
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                CategoryButton.this.scrollRectToVisible(CategoryButton.this.getBounds());
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.initActions();
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "moveFocusDown");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "moveFocusUp");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "collapse");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "expand");
        inputMap.put(KeyStroke.getKeyStroke(121, 64, false), "popup");
        inputMap.put(KeyStroke.getKeyStroke("ctrl V"), "paste");
        inputMap.put(KeyStroke.getKeyStroke("PASTE"), "paste");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("moveFocusDown", new MoveFocusAction(true));
        actionMap.put("moveFocusUp", new MoveFocusAction(false));
        actionMap.put("collapse", new ExpandAction(false));
        actionMap.put("expand", new ExpandAction(true));
        actionMap.put("popup", new PopupAction());
        Node node = (Node)this.category.getLookup().lookup(Node.class);
        if (null != node) {
            actionMap.put("paste", new Utils.PasteItemAction(node));
        }
    }

    void updateProperties() {
        this.setIcon(UIManager.getIcon(isGTK ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon"));
        this.setSelectedIcon(UIManager.getIcon(isGTK ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon"));
        this.setRolloverIcon(UIManager.getIcon(isGTK ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon"));
        this.setRolloverSelectedIcon(UIManager.getIcon(isGTK ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon"));
        Mnemonics.setLocalizedText((AbstractButton)this, (String)this.category.getDisplayName());
        this.setToolTipText(this.category.getShortDescription());
        this.getAccessibleContext().setAccessibleName(this.category.getDisplayName());
        this.getAccessibleContext().setAccessibleDescription(this.category.getShortDescription());
        if (isAqua) {
            this.setContentAreaFilled(true);
            this.setOpaque(true);
            this.setBackground(new Color(0, 0, 0));
            this.setForeground(new Color(255, 255, 255));
        }
        if (isNimbus) {
            this.setOpaque(true);
            this.setContentAreaFilled(true);
        }
    }

    Category getCategory() {
        return this.category;
    }

    public void autoscroll(Point point) {
        Container container = this.getParent().getParent();
        if (null == container || null == SwingUtilities.getWindowAncestor(container)) {
            return;
        }
        Point point2 = SwingUtilities.convertPoint(this, point, container);
        this.getSupport().autoscroll(point2);
    }

    public Insets getAutoscrollInsets() {
        return this.getSupport().getAutoscrollInsets();
    }

    boolean isExpanded() {
        return this.isSelected();
    }

    void setExpanded(boolean bl) {
        this.setSelected(bl);
        if (this.descriptor.isOpened() == bl) {
            return;
        }
        this.descriptor.setOpened(bl);
        this.descriptor.getPalettePanel().computeHeights(bl ? this.category : null);
        this.requestFocus();
    }

    AutoscrollSupport getSupport() {
        if (null == this.support) {
            this.support = new AutoscrollSupport(PalettePanel.getDefault());
        }
        return this.support;
    }

    public Color getBackground() {
        if (this.isFocusOwner()) {
            if (isGTK || isNimbus) {
                return UIManager.getColor("Tree.selectionBackground");
            }
            return UIManager.getColor("PropSheet.selectedSetBackground");
        }
        if (isAqua) {
            return UIManager.getColor("NbExplorerView.background");
        }
        if (isGTK || isNimbus) {
            if (this.getModel().isRollover()) {
                return new Color(UIManager.getColor("Menu.background").getRGB()).darker();
            }
            return new Color(UIManager.getColor("Menu.background").getRGB());
        }
        return UIManager.getColor("PropSheet.setBackground");
    }

    public Color getForeground() {
        if (this.isFocusOwner()) {
            if (isAqua) {
                return UIManager.getColor("Table.foreground");
            }
            if (isGTK || isNimbus) {
                return UIManager.getColor("Tree.selectionForeground");
            }
            return UIManager.getColor("PropSheet.selectedSetForeground");
        }
        if (isAqua) {
            Color color = UIManager.getColor("PropSheet.setForeground");
            if (color == null && (color = UIManager.getColor("Table.foreground")) == null && (color = UIManager.getColor("textText")) == null) {
                color = Color.BLACK;
            }
            return color;
        }
        if (isGTK || isNimbus) {
            return new Color(UIManager.getColor("Menu.foreground").getRGB());
        }
        return super.getForeground();
    }

    static {
        if (isGTK) {
            UIManager.put("MetalCheckBoxUI_4_GTK", "javax.swing.plaf.metal.MetalCheckBoxUI");
        }
    }

    private class PopupAction
    extends AbstractAction {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action[] actionArray = CategoryButton.this.category.getActions();
            JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Component)CategoryButton.this);
            Utils.addCustomizationMenuItems(jPopupMenu, CategoryButton.this.descriptor.getPalettePanel().getController(), CategoryButton.this.descriptor.getPalettePanel().getSettings());
            jPopupMenu.show(CategoryButton.this.getParent(), 0, CategoryButton.this.getHeight());
        }
    }

    private class ExpandAction
    extends AbstractAction {
        private boolean expand;

        public ExpandAction(boolean bl) {
            this.expand = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.expand == CategoryButton.this.isExpanded()) {
                return;
            }
            CategoryButton.this.setExpanded(this.expand);
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private boolean moveDown;

        public MoveFocusAction(boolean bl) {
            this.moveDown = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Container container = keyboardFocusManager.getCurrentFocusCycleRoot();
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            if (null == focusTraversalPolicy) {
                focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
            }
            Component component2 = component = this.moveDown ? focusTraversalPolicy.getComponentAfter(container, CategoryButton.this) : focusTraversalPolicy.getComponentBefore(container, CategoryButton.this);
            if (null != component && component instanceof CategoryList) {
                if (((CategoryList)component).getModel().getSize() != 0) {
                    ((CategoryList)component).takeFocusFrom(CategoryButton.this);
                    return;
                }
                Component component3 = component = this.moveDown ? focusTraversalPolicy.getComponentAfter(container, component) : focusTraversalPolicy.getComponentBefore(container, component);
            }
            if (null != component && component instanceof CategoryButton) {
                component.requestFocus();
            }
        }
    }
}

