/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.utilities.queries.SettingsFolderQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class IDESettingsPersistor
implements SettingsPersistor {
    public void loadSettings() {
        Properties properties = this.loadProperties();
        this.parsePersistableSettings(properties);
    }

    public void storeSettings() {
        Properties properties = this.loadProperties();
        Properties properties2 = this.preparePersistableSettings();
        this.mergeProperties(properties2, properties);
        this.storeProperties(properties);
    }

    protected abstract String getSettingsFileName();

    protected abstract void parsePersistableSettings(Properties var1);

    protected abstract Properties preparePersistableSettings();

    private File getSettingsFile() {
        FileObject fileObject = null;
        try {
            fileObject = SettingsFolderQuery.getDefault().getSettingsFolder(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file = fileObject == null ? null : FileUtil.toFile((FileObject)fileObject);
        return new File(file, this.getSettingsFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        try {
            fileInputStream = new FileInputStream(this.getSettingsFile());
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    private void mergeProperties(Properties properties, Properties properties2) {
        Set<Object> set = properties.keySet();
        for (String string : set) {
            String string2 = properties.getProperty(string);
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties(Properties properties) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getSettingsFile());
            properties.store(fileOutputStream, "");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

