/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.attach.wizard.TitleCollectingStepVisitor;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.openide.WizardDescriptor;

public abstract class AbstractWizard
implements WizardDescriptor.Iterator,
ChangeListener {
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private volatile WizardDescriptor wizardDescriptor = null;
    private WizardStep wizardModel = null;
    private boolean initialized = false;

    public WizardDescriptor getWizardDescriptor() {
        if (this.wizardDescriptor == null) {
            this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this);
            this.init();
        }
        return this.wizardDescriptor;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public WizardDescriptor.Panel current() {
        return (WizardDescriptor.Panel)this.wizardModel.getAttachedScreen();
    }

    public void finish() {
        this.getRootStep().onFinish();
    }

    public boolean hasNext() {
        return !this.wizardModel.isLast() && this.wizardModel.canNext();
    }

    public boolean hasPrevious() {
        return !this.wizardModel.isFirst() && this.wizardModel.canBack();
    }

    public final synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.prepareWizardModel();
        this.getWizardDescriptor().setTitle(this.getTitle());
        this.getWizardDescriptor().setTitleFormat(new MessageFormat(this.getTitleFormat()));
        this.getWizardDescriptor().putProperty("WizardPanel_autoWizardStyle", (Object)this.isAutoWizard());
        this.getWizardDescriptor().putProperty("WizardPanel_contentDisplayed", (Object)this.isContentDisplayed());
        this.getWizardDescriptor().putProperty("WizardPanel_contentNumbered", (Object)this.isNumbered());
        this.getWizardDescriptor().putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        this.getWizardDescriptor().putProperty("WIZARD_CONTEXT", (Object)this.getContext());
        this.wizardModel.setFirst();
        this.updateWizardSteps();
        this.initialized = true;
    }

    public String name() {
        return this.getTitle();
    }

    public void nextPanel() {
        this.wizardModel.setNext();
        this.updateWizardSteps();
    }

    public void previousPanel() {
        this.wizardModel.setPrevious();
        this.updateWizardSteps();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateWizardSteps();
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized void invalidate() {
        this.initialized = false;
        this.listeners.clear();
        this.wizardDescriptor = null;
    }

    protected abstract boolean isAutoWizard();

    protected abstract boolean isContentDisplayed();

    protected abstract WizardContext getContext();

    protected abstract boolean isHelpDisplayed();

    protected abstract boolean isNumbered();

    protected abstract WizardStep getRootStep();

    protected abstract String getTitle();

    protected abstract String getTitleFormat();

    protected abstract void onUpdateWizardSteps();

    private void prepareWizardModel() {
        if (this.wizardModel != null) {
            this.wizardModel.removeChangeListener(this);
        }
        this.wizardModel = this.getRootStep();
        this.wizardModel.addChangeListener(this);
    }

    private void updateWizardSteps() {
        this.onUpdateWizardSteps();
        TitleCollectingStepVisitor titleCollectingStepVisitor = new TitleCollectingStepVisitor();
        this.wizardModel.accept(titleCollectingStepVisitor, this.getContext(), 0);
        this.wizardDescriptor.putProperty("WizardPanel_contentData", (Object)titleCollectingStepVisitor.getTitleArray());
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(titleCollectingStepVisitor.getTitleIndex()));
        this.wizardDescriptor.setTitle(this.wizardModel.getTitle());
    }
}

