/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import java.awt.Image;
import java.net.PasswordAuthentication;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.bugzilla.kenai.KenaiConfiguration;
import org.netbeans.modules.bugzilla.kenai.KenaiQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class KenaiRepository
extends BugzillaRepository {
    static final String ICON_PATH = "org/netbeans/modules/bugtracking/ui/resources/kenai-small.png";
    private String urlParam;
    private Image icon;
    private String product;
    private KenaiQuery myIssues;
    private KenaiQuery allIssues;
    private String host;

    public KenaiRepository(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, KenaiRepository.getKenaiUser(), KenaiRepository.getKenaiPassword(), null, null);
        this.urlParam = string4;
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.product = string5;
        this.host = string3;
    }

    public Image getIcon() {
        return this.icon;
    }

    public Query createQuery() {
        KenaiQuery kenaiQuery = new KenaiQuery(null, this, null, this.product, false, false);
        return kenaiQuery;
    }

    public Issue createIssue() {
        return super.createIssue();
    }

    public synchronized Query[] getQueries() {
        Query[] queryArray = super.getQueries();
        Query[] queryArray2 = this.getDefinedQueries();
        Query[] queryArray3 = new Query[queryArray.length + queryArray2.length];
        System.arraycopy(queryArray, 0, queryArray3, 0, queryArray.length);
        System.arraycopy(queryArray2, 0, queryArray3, queryArray.length, queryArray2.length);
        return queryArray3;
    }

    private Query[] getDefinedQueries() {
        StringBuffer stringBuffer;
        ArrayList<KenaiQuery> arrayList = new ArrayList<KenaiQuery>();
        if (KenaiUtil.isLoggedIn()) {
            if (this.myIssues == null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.urlParam);
                String string = KenaiRepository.getKenaiUser();
                if (string == null) {
                    string = "";
                }
                String string2 = string + "@" + this.host;
                stringBuffer.append(MessageFormat.format("&product={0}&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&emailassigned_to1=1&emailreporter1=1&emailtype1=exact&email1={1}", this.product, string2));
                this.myIssues = new KenaiQuery(NbBundle.getMessage(KenaiRepository.class, (String)"LBL_MyIssues"), this, stringBuffer.toString(), this.product, true, true);
            }
            arrayList.add(this.myIssues);
        }
        if (this.allIssues == null) {
            stringBuffer = new StringBuffer();
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.urlParam);
            stringBuffer.append(MessageFormat.format("&product={0}&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED", this.product));
            this.allIssues = new KenaiQuery(NbBundle.getMessage(KenaiRepository.class, (String)"LBL_AllIssues"), this, stringBuffer.toString(), this.product, true, true);
        }
        arrayList.add(this.allIssues);
        return arrayList.toArray(new Query[arrayList.size()]);
    }

    protected BugzillaConfiguration createConfiguration() {
        KenaiConfiguration kenaiConfiguration = new KenaiConfiguration(this, this.product);
        kenaiConfiguration.initialize(this, false);
        return kenaiConfiguration;
    }

    protected void setCredentials(String string, String string2) {
        super.setTaskRepository(this.getDisplayName(), this.getUrl(), string, string2, null, null, this.isShortUsernamesEnabled());
    }

    public boolean authenticate(String string) {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)true);
        if (passwordAuthentication == null) {
            return false;
        }
        String string2 = passwordAuthentication.getUserName();
        char[] cArray = passwordAuthentication.getPassword();
        this.setCredentials(string2, new String(cArray));
        return true;
    }

    private static String getKenaiUser() {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)false);
        if (passwordAuthentication != null) {
            return passwordAuthentication.getUserName();
        }
        return "";
    }

    private static String getKenaiPassword() {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)false);
        if (passwordAuthentication != null) {
            return new String(passwordAuthentication.getPassword());
        }
        return "";
    }
}

