/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.ValidateCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.RepositoryPanel;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryController
extends BugtrackingController
implements DocumentListener,
ActionListener {
    private BugzillaRepository repository;
    private RepositoryPanel panel;
    private String errorMessage;
    private boolean validateError;
    private boolean populating;

    RepositoryController(BugzillaRepository bugzillaRepository) {
        this.repository = bugzillaRepository;
        this.panel = new RepositoryPanel(this);
        this.panel.nameField.getDocument().addDocumentListener(this);
        this.panel.userField.getDocument().addDocumentListener(this);
        this.panel.urlField.getDocument().addDocumentListener(this);
        this.panel.psswdField.getDocument().addDocumentListener(this);
        this.panel.validateButton.addActionListener(this);
        this.panel.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                RepositoryController.this.populate();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpCtx getHelpContext() {
        return new HelpCtx(BugzillaRepository.class);
    }

    public boolean isValid() {
        return this.validate();
    }

    private String getUrl() {
        String string = this.panel.urlField.getText().trim();
        return string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
    }

    private String getName() {
        return this.panel.nameField.getText();
    }

    private String getUser() {
        return this.panel.userField.getText();
    }

    private String getPassword() {
        return new String(this.panel.psswdField.getPassword());
    }

    private String getHttpUser() {
        return this.panel.httpCheckBox.isSelected() ? this.panel.httpUserField.getText() : null;
    }

    private String getHttpPassword() {
        return this.panel.httpCheckBox.isSelected() ? new String(this.panel.httpPsswdField.getPassword()) : null;
    }

    private boolean isLocalUserEnabled() {
        return this.panel.cbEnableLocalUsers.isSelected();
    }

    private boolean validate() {
        String[] stringArray;
        if (this.validateError) {
            return false;
        }
        this.errorMessage = null;
        this.panel.validateButton.setEnabled(false);
        String string = this.panel.nameField.getText().trim();
        if (string.equals("")) {
            this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_MISSING_NAME");
            return false;
        }
        String[] stringArray2 = null;
        if (this.repository.getTaskRepository() == null) {
            stringArray = stringArray2 = BugzillaConfig.getInstance().getRepositories();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!string.equals(string2)) continue;
                this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_NAME_ALREADY_EXISTS");
                return false;
            }
        }
        if ((stringArray = this.getUrl()).equals("")) {
            this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_MISSING_URL");
            return false;
        }
        try {
            new URL((String)stringArray);
        }
        catch (MalformedURLException malformedURLException) {
            this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_WRONG_URL_FORMAT");
            return false;
        }
        if (this.repository.getTaskRepository() == null) {
            for (String string3 : stringArray2) {
                BugzillaRepository bugzillaRepository = BugzillaConfig.getInstance().getRepository(string3);
                if (!stringArray.trim().equals(bugzillaRepository.getUrl())) continue;
                this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_URL_ALREADY_EXISTS");
                return false;
            }
        }
        this.panel.validateButton.setEnabled(true);
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void applyChanges() {
        String string = this.panel.nameField.getText().trim();
        if (!string.equals(this.repository.getDisplayName())) {
            BugzillaConfig.getInstance().removeRepository(this.repository.getDisplayName());
        }
        this.repository.setName(string);
        this.repository.setTaskRepository(this.getName(), this.getUrl(), this.getUser(), this.getPassword(), this.getHttpUser(), this.getHttpPassword(), this.isLocalUserEnabled());
        Bugzilla.getInstance().addRepository(this.repository);
        this.repository.getNode().setName(string);
    }

    void populate() {
        if (this.repository.getTaskRepository() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RepositoryController.this.populating = true;
                    AuthenticationCredentials authenticationCredentials = RepositoryController.this.repository.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
                    ((RepositoryController)RepositoryController.this).panel.userField.setText(authenticationCredentials.getUserName());
                    ((RepositoryController)RepositoryController.this).panel.psswdField.setText(authenticationCredentials.getPassword());
                    authenticationCredentials = RepositoryController.this.repository.getTaskRepository().getCredentials(AuthenticationType.HTTP);
                    if (authenticationCredentials != null) {
                        String string = authenticationCredentials.getUserName();
                        String string2 = authenticationCredentials.getPassword();
                        if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                            ((RepositoryController)RepositoryController.this).panel.httpCheckBox.setSelected(true);
                            ((RepositoryController)RepositoryController.this).panel.httpUserField.setText(string);
                            ((RepositoryController)RepositoryController.this).panel.httpPsswdField.setText(string2);
                        }
                    }
                    ((RepositoryController)RepositoryController.this).panel.urlField.setText(RepositoryController.this.repository.getTaskRepository().getUrl());
                    ((RepositoryController)RepositoryController.this).panel.nameField.setText(RepositoryController.this.repository.getDisplayName());
                    ((RepositoryController)RepositoryController.this).panel.cbEnableLocalUsers.setSelected(RepositoryController.this.repository.isShortUsernamesEnabled());
                    RepositoryController.this.populating = false;
                    RepositoryController.this.fireDataChanged();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.populating) {
            return;
        }
        this.validateErrorOff(documentEvent);
        this.fireDataChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.populating) {
            return;
        }
        this.validateErrorOff(documentEvent);
        this.fireDataChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.populating) {
            return;
        }
        this.validateErrorOff(documentEvent);
        this.fireDataChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.validateButton) {
            this.onValidate();
        }
    }

    private void onValidate() {
        RequestProcessor requestProcessor = Bugzilla.getInstance().getRequestProcessor();
        final RequestProcessor.Task[] taskArray = new RequestProcessor.Task[1];
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                ((RepositoryController)RepositoryController.this).panel.progressPanel.setVisible(false);
                ((RepositoryController)RepositoryController.this).panel.validateLabel.setVisible(false);
                if (taskArray[0] != null) {
                    taskArray[0].cancel();
                }
                return true;
            }
        };
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RepositoryPanel.class, (String)"LBL_Validating"), (Cancellable)cancellable);
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        this.panel.progressPanel.removeAll();
        this.panel.progressPanel.add((Component)jComponent, "Center");
        taskArray[0] = requestProcessor.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                progressHandle.start();
                ((RepositoryController)RepositoryController.this).panel.progressPanel.setVisible(true);
                ((RepositoryController)RepositoryController.this).panel.validateLabel.setVisible(true);
                RepositoryController.this.panel.enableFields(false);
                ((RepositoryController)RepositoryController.this).panel.validateLabel.setText(NbBundle.getMessage(RepositoryPanel.class, (String)"LBL_Validating"));
                try {
                    RepositoryController.this.repository.resetRepository();
                    TaskRepository taskRepository = BugzillaRepository.createTaskRepository(RepositoryController.this.getName(), RepositoryController.this.getUrl(), RepositoryController.this.getUser(), RepositoryController.this.getPassword(), RepositoryController.this.getHttpUser(), RepositoryController.this.getHttpPassword(), RepositoryController.this.isLocalUserEnabled());
                    ValidateCommand validateCommand = new ValidateCommand(taskRepository);
                    RepositoryController.this.repository.getExecutor().execute(validateCommand, false);
                    if (validateCommand.hasFailed()) {
                        if (validateCommand.getErrorMessage() == null) {
                            Bugzilla.LOG.warning("validate command has failed, yet the returned error message is null.");
                            RepositoryController.this.errorMessage = NbBundle.getMessage(RepositoryController.class, (String)"MSG_VALIDATION_FAILED");
                        } else {
                            RepositoryController.this.errorMessage = validateCommand.getErrorMessage();
                        }
                        RepositoryController.this.validateError = true;
                        RepositoryController.this.fireDataChanged();
                    }
                }
                finally {
                    RepositoryController.this.panel.enableFields(true);
                    ((RepositoryController)RepositoryController.this).panel.progressPanel.setVisible(false);
                    ((RepositoryController)RepositoryController.this).panel.validateLabel.setVisible(false);
                    progressHandle.finish();
                }
            }
        });
        taskArray[0].schedule(0);
    }

    private void validateErrorOff(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.panel.userField.getDocument() || documentEvent.getDocument() == this.panel.urlField.getDocument() || documentEvent.getDocument() == this.panel.psswdField.getDocument()) {
            this.validateError = false;
        }
    }
}

