/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shingler<T extends Enum> {
    private int size;
    private BigInteger p;
    private BigInteger m;
    private BigInteger[] precomputed;

    public Shingler(Class<T> clazz, int n, int n2, long l) {
        this.size = n;
        this.p = BigInteger.valueOf(n2);
        this.m = BigInteger.valueOf(l);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        this.precomputed = new BigInteger[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            BigInteger bigInteger = BigInteger.valueOf(enumArray[i].ordinal() + 1);
            this.precomputed[i] = bigInteger.multiply(this.p.pow(n - 1));
        }
    }

    public List<Long> compute(List<T> list) {
        long l = this.computeFirst(list);
        if (l == Long.MIN_VALUE) {
            return Collections.emptyList();
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size() - this.size + 1);
        arrayList.add(l);
        for (int i = 0; i < list.size() - this.size; ++i) {
            long l2 = this.computeNext(l, (Enum)list.get(i), (Enum)list.get(i + this.size));
            arrayList.add(l2);
            l = l2;
        }
        return arrayList;
    }

    long computeFirst(List<T> list) {
        if (list.size() < this.size) {
            return Long.MIN_VALUE;
        }
        BigInteger bigInteger = BigInteger.valueOf(((Enum)list.get(0)).ordinal() + 1);
        for (int i = 1; i < this.size; ++i) {
            bigInteger = bigInteger.multiply(this.p);
            bigInteger = bigInteger.add(BigInteger.valueOf(((Enum)list.get(i)).ordinal() + 1));
        }
        return bigInteger.mod(this.m).longValue();
    }

    long computeNext(long l, T t, T t2) {
        BigInteger bigInteger = BigInteger.valueOf(((Enum)t2).ordinal() + 1);
        BigInteger bigInteger2 = BigInteger.valueOf(l);
        bigInteger2 = bigInteger2.subtract(this.getPrecomputed(t)).multiply(this.p).add(bigInteger);
        return bigInteger2.mod(this.m).longValue();
    }

    private BigInteger getPrecomputed(T t) {
        return this.precomputed[((Enum)t).ordinal()];
    }
}

