/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.codeviation.commons.patterns.Factory;
import org.codeviation.commons.utils.Iterators;
import org.netbeans.modules.kenai.FeatureData;
import org.netbeans.modules.kenai.KenaiImpl;
import org.netbeans.modules.kenai.KenaiREST;
import org.netbeans.modules.kenai.LicensesListData;
import org.netbeans.modules.kenai.ProjectData;
import org.netbeans.modules.kenai.ServicesListData;
import org.netbeans.modules.kenai.api.KenaiActivity;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiLicense;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.Persistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kenai {
    public static final String PROP_LOGIN = "login";
    public static final String PROP_LOGIN_STARTED = "login_started";
    public static final String PROP_LOGIN_FAILED = "login_failed";
    private static Kenai instance;
    private PasswordAuthentication auth = null;
    private static URL url;
    final HashMap<String, WeakReference<KenaiProject>> projectsCache = new HashMap();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final KenaiImpl impl;
    private Collection<KenaiProject> myProjects = null;

    public static synchronized Kenai getDefault() {
        if (instance == null) {
            try {
                url = new URL(System.getProperty("kenai.com.url", "https://kenai.com"));
                KenaiREST kenaiREST = new KenaiREST(url);
                instance = new Kenai(kenaiREST);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return instance;
    }

    Kenai(KenaiImpl kenaiImpl) {
        this.impl = kenaiImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String string, char[] cArray) throws KenaiException {
        PasswordAuthentication passwordAuthentication = this.auth;
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN_STARTED, null, null));
        try {
            Kenai kenai = this;
            synchronized (kenai) {
                String string2 = this.impl.verify(string, cArray);
                this.auth = new PasswordAuthentication(string2, cArray);
                this.myProjects = null;
            }
        }
        catch (KenaiException kenaiException) {
            this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN_STARTED, null, null));
            throw kenaiException;
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN, passwordAuthentication, this.auth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        PasswordAuthentication passwordAuthentication = this.auth;
        this.auth = null;
        Kenai kenai = this;
        synchronized (kenai) {
            this.myProjects = null;
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, PROP_LOGIN, passwordAuthentication, this.auth));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void register(String string, char[] cArray) throws KenaiException {
        this.impl.register(string, cArray);
    }

    public Collection<KenaiProject> searchProjects(String string) throws KenaiException {
        Collection<ProjectData> collection = this.impl.searchProjects(string);
        return new LazyCollection(collection);
    }

    public Collection<KenaiLicense> getLicenses() throws KenaiException {
        Collection<LicensesListData.LicensesListItem> collection = this.impl.getLicenses();
        return new LazyCollection(collection);
    }

    public Collection<KenaiService> getServices() throws KenaiException {
        Collection<ServicesListData.ServicesListItem> collection = this.impl.getServices();
        return new LazyCollection(collection);
    }

    public KenaiProject getProject(String string, boolean bl) throws KenaiException {
        if (bl) {
            return this._getProject(string);
        }
        KenaiProject kenaiProject = KenaiProject.get(string);
        if (kenaiProject != null) {
            return kenaiProject;
        }
        return this._getProject(string);
    }

    public KenaiProject getProject(String string) throws KenaiException {
        return this.getProject(string, false);
    }

    ProjectData getDetails(String string) throws KenaiException {
        return this.impl.getProject(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KenaiProject createProject(String string, String string2, String string3, String[] stringArray, String string4) throws KenaiException {
        if (this.auth.getUserName() == null) {
            throw new KenaiException("Guest user is not allowed to create new domains");
        }
        ProjectData projectData = this.impl.createProject(string, string2, string3, stringArray, string4);
        KenaiProject kenaiProject = KenaiProject.get(projectData);
        Kenai kenai = this;
        synchronized (kenai) {
            if (this.myProjects != null) {
                this.myProjects.add(kenaiProject);
            }
        }
        return kenaiProject;
    }

    KenaiFeature createProjectFeature(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws KenaiException {
        if (this.getPasswordAuthentication() == null) {
            throw new KenaiException("Guest user is not allowed to create new domains");
        }
        FeatureData featureData = this.impl.createProjectFeature(string, string2, string3, string4, string6, string7, string8, string5);
        return new KenaiFeature(featureData);
    }

    String checkName(String string) throws KenaiException {
        return this.impl.checkName(string);
    }

    public boolean isAuthorized(KenaiProject kenaiProject, KenaiActivity kenaiActivity) throws KenaiException {
        return this.impl.isAuthorized(kenaiProject.getName(), kenaiActivity.getFeature().getId(), kenaiActivity.getName());
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.auth;
    }

    public synchronized Collection<KenaiProject> getMyProjects() throws KenaiException {
        if (this.auth == null) {
            return Collections.emptyList();
        }
        if (this.myProjects != null) {
            return this.myProjects;
        }
        return this.getMyProjects(true);
    }

    public synchronized Collection<KenaiProject> getMyProjects(boolean bl) throws KenaiException {
        if (this.auth == null) {
            return Collections.emptyList();
        }
        if (!bl) {
            return this.getMyProjects();
        }
        Collection<ProjectData> collection = this.impl.getMyProjects();
        this.myProjects = new LinkedList<KenaiProject>(new LazyCollection(collection));
        return this.myProjects;
    }

    Collection<KenaiProject> loadProjects() {
        return Persistence.getInstance().loadProjects();
    }

    void storeProjects(Collection<KenaiProject> collection) {
        Persistence.getInstance().storeProjects(collection);
    }

    private KenaiProject _getProject(String string) throws KenaiException {
        ProjectData projectData = this.impl.getProject(string);
        return KenaiProject.get(projectData);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyCollection<I, O>
    extends AbstractCollection<O> {
        private Collection<I> delegate;

        private LazyCollection(Collection<I> collection) {
            this.delegate = collection;
        }

        @Override
        public Iterator<O> iterator() {
            return Iterators.translating(this.delegate.iterator(), new Factory<O, I>(){

                @Override
                public O create(I i) {
                    if (i instanceof ProjectData) {
                        return KenaiProject.get((ProjectData)i);
                    }
                    if (i instanceof LicensesListData.LicensesListItem) {
                        return new KenaiLicense((LicensesListData.LicensesListItem)i);
                    }
                    if (i instanceof ServicesListData.ServicesListItem) {
                        return new KenaiService((ServicesListData.ServicesListItem)i);
                    }
                    throw new IllegalStateException();
                }
            });
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

