/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.evaluation.value.Value;

public class MethodOptimizationInfo {
    private boolean hasNoSideEffects = false;
    private boolean hasSideEffects = false;
    private boolean canBeMadePrivate = true;
    private boolean catchesExceptions = false;
    private boolean branchesBackward = false;
    private boolean invokesSuperMethods = false;
    private boolean accessesPrivateCode = false;
    private boolean accessesPackageCode = false;
    private boolean accessesProtectedCode = false;
    private int invocationCount = 0;
    private int parameterSize = 0;
    private long usedParameters = 0L;
    private Value[] parameters;
    private Value returnValue;

    public MethodOptimizationInfo(Clazz clazz, Method method) {
        int n = ClassUtil.internalMethodParameterCount(method.getDescriptor(clazz));
        if ((method.getAccessFlags() & 8) == 0) {
            ++n;
        }
        if (n > 0) {
            this.parameters = new Value[n];
        }
    }

    public void setNoSideEffects() {
        this.hasNoSideEffects = true;
    }

    public boolean hasNoSideEffects() {
        return this.hasNoSideEffects;
    }

    public void setSideEffects() {
        this.hasSideEffects = true;
    }

    public boolean hasSideEffects() {
        return this.hasSideEffects;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void setCatchesExceptions() {
        this.catchesExceptions = true;
    }

    public boolean catchesExceptions() {
        return this.catchesExceptions;
    }

    public void setBranchesBackward() {
        this.branchesBackward = true;
    }

    public boolean branchesBackward() {
        return this.branchesBackward;
    }

    public void setInvokesSuperMethods() {
        this.invokesSuperMethods = true;
    }

    public boolean invokesSuperMethods() {
        return this.invokesSuperMethods;
    }

    public void setAccessesPrivateCode() {
        this.accessesPrivateCode = true;
    }

    public boolean accessesPrivateCode() {
        return this.accessesPrivateCode;
    }

    public void setAccessesPackageCode() {
        this.accessesPackageCode = true;
    }

    public boolean accessesPackageCode() {
        return this.accessesPackageCode;
    }

    public void setAccessesProtectedCode() {
        this.accessesProtectedCode = true;
    }

    public boolean accessesProtectedCode() {
        return this.accessesProtectedCode;
    }

    public void incrementInvocationCount() {
        ++this.invocationCount;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public void setParameterSize(int n) {
        this.parameterSize = n;
    }

    public int getParameterSize() {
        return this.parameterSize;
    }

    public void setParameterUsed(int n) {
        this.usedParameters |= (long)(1 << n);
    }

    public void setUsedParameters(long l) {
        this.usedParameters = l;
    }

    public boolean isParameterUsed(int n) {
        return n >= 64 || (this.usedParameters & (long)(1 << n)) != 0L;
    }

    public long getUsedParameters() {
        return this.usedParameters;
    }

    public void generalizeParameter(int n, Value value) {
        this.parameters[n] = this.parameters[n] != null ? this.parameters[n].generalize(value) : value;
    }

    public Value getParameter(int n) {
        return this.parameters != null ? this.parameters[n] : null;
    }

    public void generalizeReturnValue(Value value) {
        this.returnValue = this.returnValue != null ? this.returnValue.generalize(value) : value;
    }

    public Value getReturnValue() {
        return this.returnValue;
    }

    public static void setMethodOptimizationInfo(Clazz clazz, Method method) {
        MethodLinker.lastMember(method).setVisitorInfo(new MethodOptimizationInfo(clazz, method));
    }

    public static MethodOptimizationInfo getMethodOptimizationInfo(Method method) {
        Object object = MethodLinker.lastMember(method).getVisitorInfo();
        return object instanceof MethodOptimizationInfo ? (MethodOptimizationInfo)object : null;
    }
}

