/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.visitor;

import java.util.Stack;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.visitor.DefaultVisitor;

public class DeepAXITreeVisitor
extends DefaultVisitor {
    Stack<AXIComponent> pathToRoot = new Stack();

    public void visit(AXIDocument aXIDocument) {
        this.visitChildren(aXIDocument);
    }

    public void visit(Element element) {
        this.visitChildren(element);
    }

    public void visit(AnyElement anyElement) {
        this.visitChildren(anyElement);
    }

    public void visit(Attribute attribute) {
        this.visitChildren(attribute);
    }

    public void visit(AnyAttribute anyAttribute) {
        this.visitChildren(anyAttribute);
    }

    public void visit(Compositor compositor) {
        this.visitChildren(compositor);
    }

    public void visit(ContentModel contentModel) {
        this.visitChildren(contentModel);
    }

    protected void visitChildren(AXIComponent aXIComponent) {
        if (!this.canVisit(aXIComponent)) {
            return;
        }
        this.pathToRoot.push(aXIComponent.getOriginal());
        for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
            aXIComponent2.accept(this);
        }
        this.pathToRoot.pop();
    }

    protected boolean canVisit(AXIComponent aXIComponent) {
        ElementRef elementRef;
        Element element;
        if (this.pathToRoot.contains(aXIComponent)) {
            return false;
        }
        if (aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY) {
            return this.canVisit(aXIComponent.getOriginal());
        }
        return aXIComponent.getComponentType() != AXIComponent.ComponentType.REFERENCE || !(aXIComponent instanceof ElementRef) || !this.pathToRoot.contains(element = (elementRef = (ElementRef)aXIComponent).getReferent());
    }
}

