/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner {
    public static final Set<ElementKind> TYPE_KINDS = EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE);
    private static final Logger LOGGER = Logger.getLogger(AnnotationScanner.class.getName());
    private final AnnotationModelHelper helper;

    AnnotationScanner(AnnotationModelHelper annotationModelHelper) {
        this.helper = annotationModelHelper;
    }

    public void findAnnotations(String string, Set<ElementKind> set, AnnotationHandler annotationHandler) throws InterruptedException {
        Parameters.notNull((CharSequence)"searchedTypeName", (Object)string);
        Parameters.notNull((CharSequence)"kinds", set);
        Parameters.notNull((CharSequence)"handler", (Object)annotationHandler);
        LOGGER.log(Level.FINE, "findAnnotations called with {0} for {1}", new Object[]{string, set});
        if (set.isEmpty()) {
            LOGGER.log(Level.WARNING, "findAnnotations: no kinds given");
            return;
        }
        CompilationController compilationController = this.helper.getCompilationController();
        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
        if (typeElement == null) {
            LOGGER.log(Level.FINE, "findAnnotations: could not find type {0}", string);
            return;
        }
        ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
        Set set2 = this.helper.getClasspathInfo().getClassIndex().getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (set2 == null) {
            throw new InterruptedException("ClassIndex.getElements() was interrupted");
        }
        EnumSet<ElementKind> enumSet = EnumSet.copyOf(set);
        enumSet.removeAll(TYPE_KINDS);
        EnumSet<ElementKind> enumSet2 = EnumSet.copyOf(set);
        enumSet2.retainAll(TYPE_KINDS);
        for (ElementHandle elementHandle2 : set2) {
            LOGGER.log(Level.FINE, "found element {0}", elementHandle2.getQualifiedName());
            TypeElement typeElement2 = (TypeElement)elementHandle2.resolve((CompilationInfo)compilationController);
            if (typeElement2 == null) continue;
            if (!enumSet2.isEmpty()) {
                this.handleAnnotation(annotationHandler, typeElement2, typeElement2, string);
            }
            if (enumSet.isEmpty()) continue;
            for (Element element : typeElement2.getEnclosedElements()) {
                if (!enumSet.contains((Object)element.getKind())) continue;
                this.handleAnnotation(annotationHandler, typeElement2, element, string);
            }
        }
    }

    private void handleAnnotation(AnnotationHandler annotationHandler, TypeElement typeElement, Element element, String string) {
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : list) {
            DeclaredType declaredType = annotationMirror.getAnnotationType();
            String string2 = this.helper.getAnnotationTypeName(declaredType);
            if (string.equals(string2)) {
                LOGGER.log(Level.FINE, "notifying type {0}, element {1}, annotation {2}", new Object[]{typeElement.getQualifiedName(), element.getSimpleName(), annotationMirror});
                annotationHandler.handleAnnotation(typeElement, element, annotationMirror);
                continue;
            }
            LOGGER.log(Level.FINE, "type name mismatch, ignoring type {0}, element {1}, annotation {2}", new Object[]{typeElement.getQualifiedName(), element.getSimpleName(), annotationMirror});
        }
    }
}

