/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.sources.SVGMenuElementEventSourceCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.AbstractElementsContentHandler;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SVGMenuImageParser
extends SVGComponentImageParser {
    private static final String MENU_ELEMENT_SEARCH_PATTERN = "menuItem_.*";

    public void parse(InputStream inputStream, DesignComponent designComponent) {
        SVGMenuImageParser.parseSVGMenu(inputStream, designComponent);
    }

    public static void parseSVGMenu(InputStream inputStream, final DesignComponent designComponent) {
        final String[] stringArray = SVGMenuImageParser.getMenuItems(inputStream);
        if (stringArray != null) {
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(stringArray.length);
                    for (String string : stringArray) {
                        DesignComponent designComponent2 = designComponent.getDocument().createComponent(SVGMenuElementEventSourceCD.TYPEID);
                        designComponent2.writeProperty("string", MidpTypes.createStringValue((String)string));
                        arrayList.add(PropertyValue.createComponentReference((DesignComponent)designComponent2));
                        designComponent.addComponent(designComponent2);
                    }
                    designComponent.writeProperty("elements", PropertyValue.createArray((TypeID)SVGMenuElementEventSourceCD.TYPEID, arrayList));
                }
            });
        }
    }

    private static String[] getMenuItems(InputStream inputStream) {
        NamedElementsContentHandler namedElementsContentHandler = new NamedElementsContentHandler(MENU_ELEMENT_SEARCH_PATTERN);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(namedElementsContentHandler);
            xMLReader.setEntityResolver(namedElementsContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        catch (SAXException sAXException) {
            Debug.warning((Object[])new Object[]{sAXException});
        }
        namedElementsContentHandler.sortNamedElements();
        return namedElementsContentHandler.getFoundElements();
    }

    private static class NamedElementsContentHandler
    extends AbstractElementsContentHandler {
        private ArrayList<String> foundElements = new ArrayList();
        private Pattern regex;

        public NamedElementsContentHandler(String string) {
            this.regex = Pattern.compile(string);
        }

        public void sortNamedElements() {
            Collections.sort(this.foundElements);
        }

        public String[] getFoundElements() {
            return this.foundElements.toArray(new String[this.foundElements.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue("id");
            if (string4 != null && this.regex.matcher(string4).matches()) {
                this.foundElements.add(string4);
            }
        }
    }
}

