/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Graphics;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import javax.swing.JPanel;

public class SVGImageComponent
extends JPanel {
    private SVGImage image;
    private int originalVieportWidth;
    private int originalVieportHeight;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int correctionX = 0;
    private int correctionY = 0;

    public SVGImageComponent() {
        this.setOpaque(false);
    }

    public SVGImage getImage() {
        return this.image;
    }

    public void setImage(SVGImage sVGImage) {
        SVGImage sVGImage2 = this.image;
        if (sVGImage2 == sVGImage) {
            return;
        }
        this.image = sVGImage;
        if (sVGImage != null) {
            this.originalVieportWidth = sVGImage.getViewportWidth();
            this.originalVieportHeight = sVGImage.getViewportHeight();
        }
        this.firePropertyChange("svg-image", sVGImage2, sVGImage);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.image != null) {
            this.updateScale();
            if (this.getHeight() < this.originalVieportHeight || this.getWidth() < this.originalVieportWidth) {
                this.image.setViewportHeight(this.getHeight());
                this.image.setViewportWidth(this.getWidth());
            } else {
                this.image.setViewportHeight(this.originalVieportHeight);
                this.image.setViewportWidth(this.originalVieportWidth);
            }
            ScalableGraphics scalableGraphics = ScalableGraphics.createInstance();
            scalableGraphics.bindTarget((Object)graphics);
            scalableGraphics.render(0, 0, (ScalableImage)this.image);
            scalableGraphics.releaseTarget();
        }
    }

    protected float getScaleX() {
        return this.scaleX;
    }

    protected float getScaleY() {
        return this.scaleY;
    }

    protected int getCorrectionX() {
        return this.correctionX;
    }

    protected int getCorrectionY() {
        return this.correctionY;
    }

    private void updateScale() {
        assert (this.image != null);
        if (this.getHeight() < this.originalVieportHeight || this.getWidth() < this.originalVieportWidth) {
            float f = (float)this.getWidth() / (float)this.originalVieportWidth;
            float f2 = (float)this.getHeight() / (float)this.originalVieportHeight;
            this.scaleY = this.scaleX = Math.min(f, f2);
            if (f2 < f) {
                int n = (int)((float)this.originalVieportWidth * this.scaleY);
                this.correctionX = (this.getWidth() - n) / 2;
                this.correctionY = 0;
            } else {
                this.correctionX = 0;
                int n = (int)((float)this.originalVieportHeight * this.scaleX);
                this.correctionY = (this.getHeight() - n) / 2;
            }
        } else {
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
            this.correctionX = 0;
            this.correctionY = 0;
        }
    }
}

