/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningMainMenu;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMenuItem
extends AbstractAction
implements Presenter.Popup {
    public JMenuItem getPopupPresenter() {
        return new DynamicDummyItem();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private JComponent[] createItems() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray.length > 0) {
            JMenu jMenu;
            Set<VersioningSystem> set = this.getOwners(nodeArray);
            if (set.size() != 1) {
                return new JComponent[0];
            }
            VersioningSystem versioningSystem = set.iterator().next();
            VersioningSystem versioningSystem2 = this.getLocalHistory(nodeArray);
            ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
            if (versioningSystem != null) {
                jMenu = this.createVersioningSystemPopup(versioningSystem, nodeArray);
                if (jMenu != null) {
                    arrayList.add(jMenu);
                }
            } else {
                jMenu = new JMenu(NbBundle.getMessage(ProjectMenuItem.class, (String)"CTL_MenuItem_VersioningMenu"));
                Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
                ArrayList arrayList2 = new ArrayList(result.allInstances());
                Collections.sort(arrayList2, new VersioningMainMenu.ByDisplayNameComparator());
                for (VersioningSystem versioningSystem3 : arrayList2) {
                    JComponent[] jComponentArray;
                    if (versioningSystem3.getProperty("Boolean VCS.LocalHistory") != null || (jComponentArray = this.createVersioningSystemItems(versioningSystem3, nodeArray)) == null) continue;
                    for (JComponent jComponent : jComponentArray) {
                        jMenu.add(jComponent);
                    }
                }
                jMenu.addSeparator();
                jMenu.add(this.createmenuItem((Action)SystemAction.get(PatchAction.class)));
                arrayList.add(jMenu);
            }
            if (versioningSystem2 != null && (jMenu = this.createVersioningSystemPopup(versioningSystem2, nodeArray)) != null) {
                arrayList.add(jMenu);
            }
            return arrayList.toArray(new JComponent[arrayList.size()]);
        }
        return new JComponent[0];
    }

    private VersioningSystem getLocalHistory(Node[] nodeArray) {
        VCSContext vCSContext = VCSContext.forNodes(nodeArray);
        VersioningSystem versioningSystem = null;
        for (File file : vCSContext.getRootFiles()) {
            VersioningSystem versioningSystem2 = VersioningManager.getInstance().getLocalHistory(file);
            if (versioningSystem != null) {
                if (versioningSystem2 == null || versioningSystem2 == versioningSystem) continue;
                return null;
            }
            versioningSystem = versioningSystem2;
        }
        return versioningSystem;
    }

    private Set<VersioningSystem> getOwners(Node[] nodeArray) {
        VCSContext vCSContext = VCSContext.forNodes(nodeArray);
        HashSet<VersioningSystem> hashSet = new HashSet<VersioningSystem>(2);
        for (File file : vCSContext.getRootFiles()) {
            VersioningSystem versioningSystem = VersioningManager.getInstance().getOwner(file);
            hashSet.add(versioningSystem);
        }
        return hashSet;
    }

    private JComponent[] createVersioningSystemItems(VersioningSystem versioningSystem, Node[] nodeArray) {
        VCSAnnotator vCSAnnotator = versioningSystem.getVCSAnnotator();
        if (vCSAnnotator == null) {
            return null;
        }
        VCSContext vCSContext = VCSContext.forNodes(nodeArray);
        Action[] actionArray = vCSAnnotator.getActions(vCSContext, VCSAnnotator.ActionDestination.PopupMenu);
        JComponent[] jComponentArray = new JComponent[actionArray.length];
        int n = 0;
        for (Action action : actionArray) {
            if (action == null) {
                jComponentArray[n++] = Utils.createJSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createmenuItem(action);
            jComponentArray[n++] = jMenuItem;
        }
        return jComponentArray;
    }

    private JMenuItem createmenuItem(Action action) {
        JMenuItem jMenuItem;
        if (action instanceof SystemAction) {
            final SystemAction systemAction = (SystemAction)action;
            jMenuItem = new JMenuItem(new AbstractAction(systemAction.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    systemAction.actionPerformed(actionEvent);
                }
            });
        } else {
            jMenuItem = new JMenuItem(action);
        }
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)((String)action.getValue("Name")));
        return jMenuItem;
    }

    private JMenu createVersioningSystemPopup(VersioningSystem versioningSystem, Node[] nodeArray) {
        JComponent[] jComponentArray = this.createVersioningSystemItems(versioningSystem, nodeArray);
        if (jComponentArray == null) {
            return null;
        }
        JMenu jMenu = new JMenu(Utils.getDisplayName(versioningSystem));
        for (JComponent jComponent : jComponentArray) {
            jMenu.add(jComponent);
        }
        return jMenu;
    }

    private Node[] getActivatedNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private class DynamicDummyItem
    extends JMenuItem
    implements DynamicMenuContent {
        private DynamicDummyItem() {
        }

        public JComponent[] getMenuPresenters() {
            return ProjectMenuItem.this.createItems();
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return ProjectMenuItem.this.createItems();
        }
    }
}

