/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

final class BreakpointLineUpdater
implements PropertyChangeListener {
    private final RubyLineBreakpoint breakpoint;
    private DataObject dataObject;
    private Line line;

    public BreakpointLineUpdater(RubyLineBreakpoint rubyLineBreakpoint) {
        this.breakpoint = rubyLineBreakpoint;
        try {
            this.dataObject = DataObject.find((FileObject)rubyLineBreakpoint.getFileObject());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public synchronized void attach() throws IOException {
        this.breakpoint.addPropertyChangeListener(this);
        try {
            LineCookie lineCookie = (LineCookie)this.dataObject.getCookie(LineCookie.class);
            this.line = lineCookie.getLineSet().getCurrent(this.breakpoint.getLineNumber() - 1);
            this.line.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized void detach() {
        this.breakpoint.removePropertyChangeListener(this);
        if (this.line != null) {
            this.line.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("lineNumber".equals(propertyChangeEvent.getPropertyName()) && this.line == propertyChangeEvent.getSource()) {
            this.breakpoint.notifyUpdated();
            return;
        }
    }
}

