/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.ejbjar.CarAccessor;
import org.netbeans.modules.j2ee.spi.ejbjar.CarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.CarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.CarsInProject;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Car {
    private CarImplementation impl;
    private static final Lookup.Result<CarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(CarProvider.class));

    private Car(CarImplementation carImplementation) {
        if (carImplementation == null) {
            throw new IllegalArgumentException();
        }
        this.impl = carImplementation;
    }

    public static Car getCar(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to Car.getCar(FileObject)");
        }
        for (CarProvider carProvider : implementations.allInstances()) {
            Car car = carProvider.findCar(fileObject);
            if (car == null) continue;
            return car;
        }
        return null;
    }

    public static Car[] getCars(Project project) {
        Car[] carArray;
        CarsInProject carsInProject = (CarsInProject)project.getLookup().lookup(CarsInProject.class);
        if (carsInProject != null && (carArray = carsInProject.getCars()) != null) {
            return carArray;
        }
        return new Car[0];
    }

    public String getJ2eePlatformVersion() {
        return this.impl.getJ2eePlatformVersion();
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public FileObject[] getJavaSources() {
        return this.impl.getJavaSources();
    }

    public FileObject getMetaInf() {
        return this.impl.getMetaInf();
    }

    static {
        CarAccessor.DEFAULT = new CarAccessor(){

            public Car createCar(CarImplementation carImplementation) {
                return new Car(carImplementation);
            }

            public CarImplementation getCarImplementation(Car car) {
                return car == null ? null : car.impl;
            }
        };
    }
}

