/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjar.EarAccessor;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Ear {
    private final EarImplementation impl;
    private static final Lookup.Result<EarProvider> implementations = Lookup.getDefault().lookup(new Lookup.Template(EarProvider.class));

    private Ear(EarImplementation earImplementation) {
        if (earImplementation == null) {
            throw new IllegalArgumentException();
        }
        this.impl = earImplementation;
    }

    public static Ear getEar(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to Ear.getEar(FileObject)");
        }
        for (EarProvider earProvider : implementations.allInstances()) {
            Ear ear = earProvider.findEar(fileObject);
            if (ear == null) continue;
            return ear;
        }
        return null;
    }

    public String getJ2eePlatformVersion() {
        return this.impl.getJ2eePlatformVersion();
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public void addWebModule(WebModule webModule) {
        this.impl.addWebModule(webModule);
    }

    public void addEjbJarModule(EjbJar ejbJar) {
        this.impl.addEjbJarModule(ejbJar);
    }

    public void addCarModule(Car car) {
        this.impl.addCarModule(car);
    }

    static {
        EarAccessor.DEFAULT = new EarAccessor(){

            public Ear createEar(EarImplementation earImplementation) {
                return new Ear(earImplementation);
            }

            public EarImplementation getEarImplementation(Ear ear) {
                return ear == null ? null : ear.impl;
            }
        };
    }
}

