/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLightExecutorService {
    private static final String PREFIX = "DLIGHT: ";
    private static final RequestProcessor processor = new RequestProcessor("DLIGHT: ", 50);
    private static final Object lock = new String(DLightExecutorService.class.getName());

    public static <T> Future<T> submit(final Callable<T> callable, final String string) {
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Thread.currentThread().setName(DLightExecutorService.PREFIX + string);
                return callable.call();
            }
        });
        processor.post(futureTask);
        return futureTask;
    }

    public static void submit(final Runnable runnable, final String string) {
        processor.post(new Runnable(){

            public void run() {
                Thread.currentThread().setName(DLightExecutorService.PREFIX + string);
                runnable.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future scheduleAtFixedRate(Runnable runnable, long l, TimeUnit timeUnit, String string) {
        Object object = lock;
        synchronized (object) {
            final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new TaskThreadFactory(string));
            final ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, l, timeUnit);
            DLightExecutorService.submit(new Runnable(){

                public void run() {
                    while (!scheduledFuture.isDone()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return scheduledExecutorService.shutdownNow();
                        }
                    });
                }
            }, string + " reaper");
            return scheduledFuture;
        }
    }

    static class TaskThreadFactory
    implements ThreadFactory {
        static final AtomicInteger threadNumber = new AtomicInteger(1);
        static final String namePrefix = "DLIGHT: ScheduledExecutorService No. ";
        final String threadName;
        final ThreadGroup group;

        TaskThreadFactory(String string) {
            this.threadName = namePrefix + threadNumber.getAndIncrement() + " [ " + string + " ]";
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Thread newThread(Runnable runnable) {
            Object object = lock;
            synchronized (object) {
                Thread thread = new Thread(this.group, runnable, this.threadName, 0L);
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        }
    }
}

