/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger log = DLightLogger.getLogger(Util.class);

    private static String getFullPath(String string) {
        File file = InstalledFileLocator.getDefault().locate(string, null, false);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return string;
    }

    public static String copyResource(Class clazz, String string) {
        try {
            InputStream inputStream = clazz.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            if (hostInfo == null) {
                return null;
            }
            String string2 = "_dlight_" + Util.getBriefName(string);
            String string3 = hostInfo.getTempDir();
            HostInfo.OSFamily oSFamily = hostInfo.getOSFamily();
            hostInfo.getOSFamily();
            if (oSFamily == HostInfo.OSFamily.WINDOWS) {
                string3 = WindowsSupport.getInstance().convertToWindowsPath(string3);
            }
            File file = File.createTempFile(string2, ".d", new File(string3));
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            inputStream.close();
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            log.info("copyResource failed: " + iOException.getMessage());
            return null;
        }
    }

    private static String getBriefName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n > 0 ? string.substring(0, n) : string;
        n = string.lastIndexOf(47);
        string2 = n >= 0 ? string.substring(n + 1) : string;
        return string2;
    }

    public static void setExecutionPermissions(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object arrayList2 = list.iterator();
        while (arrayList2.hasNext()) {
            String object2;
            String iOException = object2 = arrayList2.next();
            if (!new File(object2).exists()) {
                iOException = Util.getFullPath(object2);
            }
            if (!new File(iOException).exists()) continue;
            arrayList.add(iOException);
        }
        arrayList2 = new ArrayList();
        arrayList2.add("/bin/chmod");
        arrayList2.add("755");
        arrayList2.addAll(arrayList);
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)arrayList2);
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getBasePath(Class clazz) {
        String string = clazz.getName().replace('.', '/');
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(0, n) : string;
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    public static boolean deleteLocalDirectory(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Util.deleteLocalDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }
}

