/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.spi.AcegiAuthorizer;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.openide.util.Lookup;

public class AcegiConnectionAuthenticator
implements ConnectionAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(AcegiConnectionAuthenticator.class.getName());
    private static final Map<URL, String[]> COOKIES = new HashMap<URL, String[]>();

    public void prepareRequest(URLConnection uRLConnection, URL uRL) {
        if (COOKIES.containsKey(uRL)) {
            for (String string : COOKIES.get(uRL)) {
                String string2 = string.replaceFirst(";.*", "");
                LOGGER.log(Level.FINER, "Setting cookie {0} for {1}", new Object[]{string2, uRLConnection.getURL()});
                uRLConnection.setRequestProperty("Cookie", string2);
            }
        }
    }

    public URLConnection forbidden(URLConnection uRLConnection, URL uRL) {
        for (AcegiAuthorizer acegiAuthorizer : Lookup.getDefault().lookupAll(AcegiAuthorizer.class)) {
            String[] stringArray = acegiAuthorizer.authorize(uRL);
            if (stringArray == null) continue;
            LOGGER.log(Level.FINE, "Got authorization for {0} on {1} from {2}", new Object[]{stringArray[0], uRL, acegiAuthorizer});
            try {
                HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
                new ConnectionBuilder().url(new URL(uRL, "j_acegi_security_check")).postData(("j_username=" + URLEncoder.encode(stringArray[0], "UTF-8") + "&j_password=" + URLEncoder.encode(stringArray[1], "UTF-8")).getBytes("UTF-8")).collectResponseHeaders(hashMap).connection();
                List list = (List)hashMap.get("Set-Cookie");
                if (list == null) {
                    LOGGER.log(Level.FINE, "No cookies set from authentication to {0}", uRL);
                    return null;
                }
                LOGGER.log(Level.FINE, "Authenticated to {0}: {1}", new Object[]{uRL, list});
                COOKIES.put(uRL, list.toArray(new String[0]));
                return uRLConnection.getURL().openConnection();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
            }
        }
        return null;
    }
}

