/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.nodes.HudsonArtifactsNode;
import org.netbeans.modules.hudson.ui.nodes.HudsonMavenModuleBuildNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class HudsonJobBuildNode
extends AbstractNode {
    private final HudsonJobBuild build;
    private String htmlDisplayName;

    public HudsonJobBuildNode(HudsonJobBuild hudsonJobBuild) {
        super(HudsonJobBuildNode.makeChildren(hudsonJobBuild), Lookups.singleton((Object)hudsonJobBuild));
        HudsonJob.Color color;
        this.setName(Integer.toString(hudsonJobBuild.getNumber()));
        this.setDisplayName(NbBundle.getMessage(HudsonJobBuildNode.class, (String)"HudsonJobBuildNode.displayName", (Object)hudsonJobBuild.getNumber()));
        if (hudsonJobBuild.isBuilding()) {
            color = hudsonJobBuild.getJob().getColor();
        } else {
            switch (hudsonJobBuild.getResult()) {
                case SUCCESS: {
                    color = HudsonJob.Color.blue;
                    break;
                }
                case UNSTABLE: {
                    color = HudsonJob.Color.yellow;
                    break;
                }
                case FAILURE: {
                    color = HudsonJob.Color.red;
                    break;
                }
                default: {
                    color = HudsonJob.Color.grey;
                }
            }
        }
        try {
            this.htmlDisplayName = color.colorizeDisplayName(XMLUtil.toElementContent((String)this.getDisplayName()));
        }
        catch (CharConversionException charConversionException) {
            this.htmlDisplayName = null;
        }
        this.setIconBaseWithExtension(color.iconBase());
        this.build = hudsonJobBuild;
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(UI.showChangesAction(this.build));
        arrayList.add(UI.showConsoleAction(this.build));
        if (this.build.getResult() == HudsonJobBuild.Result.UNSTABLE && this.build.getMavenModules().isEmpty()) {
            arrayList.add(UI.showFailuresAction(this.build));
        }
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(OpenUrlAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static Children makeChildren(final HudsonJobBuild hudsonJobBuild) {
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object ARTIFACTS = new Object();

            protected boolean createKeys(List<Object> list) {
                Collection<? extends HudsonMavenModuleBuild> collection = hudsonJobBuild.getMavenModules();
                if (collection.isEmpty()) {
                    list.add(this.ARTIFACTS);
                } else {
                    list.addAll(collection);
                }
                return true;
            }

            protected Node createNodeForKey(Object object) {
                if (object instanceof HudsonMavenModuleBuild) {
                    return new HudsonMavenModuleBuildNode((HudsonMavenModuleBuild)object);
                }
                assert (object == this.ARTIFACTS) : object;
                return new HudsonArtifactsNode(hudsonJobBuild);
            }
        }, (boolean)false);
    }
}

