/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.actions.StartJobAction;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobBuildNode;
import org.netbeans.modules.hudson.ui.nodes.HudsonWorkspaceNode;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class HudsonJobNode
extends AbstractNode {
    private String htmlDisplayName;
    private HudsonJob job;

    public HudsonJobNode(HudsonJob hudsonJob) {
        super(HudsonJobNode.makeChildren(hudsonJob), Lookups.singleton((Object)hudsonJob));
        this.setName(hudsonJob.getName());
        this.setHudsonJob(hudsonJob);
    }

    private static Children makeChildren(final HudsonJob hudsonJob) {
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object WORKSPACE = new Object();

            protected boolean createKeys(List<Object> list) {
                list.add(this.WORKSPACE);
                list.addAll(hudsonJob.getBuilds());
                return true;
            }

            protected Node createNodeForKey(Object object) {
                if (object == this.WORKSPACE) {
                    return new HudsonWorkspaceNode(hudsonJob);
                }
                return new HudsonJobBuildNode((HudsonJobBuild)object);
            }
        }, (boolean)true);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        arrayList.add(SystemAction.get(StartJobAction.class));
        arrayList.add(null);
        arrayList.add(SystemAction.get(OpenUrlAction.class));
        arrayList.add(SystemAction.get(PropertiesAction.class));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        sheet.put(((HudsonJobImpl)this.job).getSheetSet());
        return sheet;
    }

    private void setHudsonJob(HudsonJob hudsonJob) {
        this.job = hudsonJob;
        HudsonJob.Color color = hudsonJob.getColor();
        this.setShortDescription(hudsonJob.getUrl());
        this.setIconBaseWithExtension(color.iconBase());
        String string = this.getHtmlDisplayName();
        try {
            this.htmlDisplayName = color.colorizeDisplayName(XMLUtil.toElementContent((String)hudsonJob.getDisplayName()));
        }
        catch (CharConversionException charConversionException) {
            assert (false) : charConversionException;
            return;
        }
        if (!hudsonJob.isSalient()) {
            // empty if block
        }
        switch (color) {
            case red_anime: 
            case yellow_anime: 
            case blue_anime: 
            case grey_anime: 
            case aborted_anime: {
                this.htmlDisplayName = this.htmlDisplayName + " <font color='!controlShadow'>" + NbBundle.getMessage(HudsonJobNode.class, (String)"HudsonJobNode.running") + "</font>";
            }
        }
        if (hudsonJob.isInQueue()) {
            this.htmlDisplayName = this.htmlDisplayName + " <font color='!controlShadow'>" + NbBundle.getMessage(HudsonJobNode.class, (String)"HudsonJobNode.in_queue") + "</font>";
        }
        this.fireDisplayNameChange(string, this.htmlDisplayName);
    }
}

